-------------------------------------------------------------------------------
--   ____  ____ 
--  /   /\/   / 
-- /___/  \  /    Vendor: Xilinx 
-- \   \   \/     Version : 1.12
--  \   \         Application : Virtex-6 FPGA GTX Transceiver Wizard
--  /   /         Filename : frame_gen.vhd
-- /___/   /\      
-- \   \  /  \ 
--  \___\/\___\ 
--
--
-- Module FRAME_GEN
-- Generated by Xilinx Virtex-6 FPGA GTX Transceiver Wizard
-- 
-- 
-- (c) Copyright 2009-2011 Xilinx, Inc. All rights reserved.
-- 
-- This file contains confidential and proprietary information
-- of Xilinx, Inc. and is protected under U.S. and
-- international copyright and other intellectual property
-- laws.
-- 
-- DISCLAIMER
-- This disclaimer is not a license and does not grant any
-- rights to the materials distributed herewith. Except as
-- otherwise provided in a valid license issued to you by
-- Xilinx, and to the maximum extent permitted by applicable
-- law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
-- WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
-- AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
-- BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
-- INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
-- (2) Xilinx shall not be liable (whether in contract or tort,
-- including negligence, or under any other theory of
-- liability) for any loss or damage of any kind or nature
-- related to, arising under or in connection with these
-- materials, including for any direct, or any indirect,
-- special, incidental, or consequential loss or damage
-- (including loss of data, profits, goodwill, or any type of
-- loss or damage suffered as a result of any action brought
-- by a third party) even if such damage or loss was
-- reasonably foreseeable or Xilinx had been advised of the
-- possibility of the same.
-- 
-- CRITICAL APPLICATIONS
-- Xilinx products are not designed or intended to be fail-
-- safe, or for use in any application requiring fail-safe
-- performance, such as life-support or safety devices or
-- systems, Class III medical devices, nuclear facilities,
-- applications related to the deployment of airbags, or any
-- other applications that could lead to death, personal
-- injury, or severe property or environmental damage
-- (individually and collectively, "Critical
-- Applications"). Customer assumes the sole risk and
-- liability of any use of Xilinx products in Critical
-- Applications, subject only to applicable laws and
-- regulations governing limitations on product liability.
-- 
-- THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
-- PART OF THIS FILE AT ALL TIMES. 


library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;

--***********************************Entity Declaration************************

entity FRAME_GEN is
generic
(
    WORDS_IN_BRAM : integer    :=   256;
    MEM_00       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_01       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_02       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_03       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_04       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_05       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_06       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_07       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_08       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_09       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_0A       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_0B       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_0C       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_0D       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_0E       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_0F       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_10       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_11       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_12       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_13       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_14       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_15       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_16       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_17       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_18       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_19       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_1A       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_1B       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_1C       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_1D       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_1E       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_1F       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_20       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_21       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_22       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_23       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_24       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_25       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_26       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_27       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_28       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_29       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_2A       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_2B       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_2C       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_2D       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_2E       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_2F       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_30       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_31       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_32       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_33       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_34       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_35       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_36       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_37       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_38       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_39       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_3A       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_3B       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_3C       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_3D       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_3E       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_3F       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEMP_00      : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEMP_01      : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEMP_02      : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEMP_03      : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEMP_04      : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEMP_05      : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEMP_06      : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEMP_07      : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000"
);    
port
(
    -- User Interface
    TX_DATA             : out   std_logic_vector(39 downto 0);
    TX_CHARISK          : out   std_logic_vector(3 downto 0); 

    -- System Interface
    USER_CLK            : in    std_logic;      
    SYSTEM_RESET        : in    std_logic
); 


end FRAME_GEN;

architecture RTL of FRAME_GEN is

--***********************************Parameter Declarations********************

    constant DLY : time := 1 ns;

--********************************* Wire Declarations************************** 

    signal  tx_charisk_i            :   std_logic_vector(3 downto 0);
    signal  tx_data_bram_i          :   std_logic_vector(31 downto 0);
    signal  tied_to_ground_vec_i    :   std_logic_vector(31 downto 0);
    signal  tied_to_ground_i        :   std_logic;
    signal  tied_to_vcc_i           :   std_logic;
    signal  tied_to_vcc_vec_i       :   std_logic_vector(15 downto 0);

--***************************Internal signalister Declarations******************** 

    signal  read_counter_i          :   unsigned(8 downto 0);    


--*********************************Main Body of Code***************************
begin

    tied_to_ground_vec_i    <=   (others=>'0');
    tied_to_ground_i        <=   '0';
    tied_to_vcc_i           <=   '1';
            
    --__________________________ Counter to read from BRAM ____________________    
    
    process( USER_CLK )
    begin
        if(USER_CLK'event and USER_CLK = '1') then
            if((SYSTEM_RESET='1') or (read_counter_i = (WORDS_IN_BRAM-1)))then
                read_counter_i <= (others => '0') after DLY;
            else
                read_counter_i <= read_counter_i + 1 after DLY;
            end if;
        end if;
    end process;

    -- Assign TX_DATA to BRAM output
    process( USER_CLK )
    begin
        if(USER_CLK'event and USER_CLK = '1') then
            if(SYSTEM_RESET='1') then
                TX_DATA      <= (others => '0') after DLY;
            else
                TX_DATA      <= (tied_to_ground_vec_i(7 downto 0) & tx_data_bram_i) after DLY; 
            end if;
        end if;
    end process;

    -- Assign TX_CHARISK to BRAM output
    process( USER_CLK )
    begin
        if(USER_CLK'event and USER_CLK = '1') then
            if(SYSTEM_RESET='1') then
                TX_CHARISK    <= (others => '0') after DLY;
            else
                TX_CHARISK    <= tx_charisk_i after DLY; 
            end if;
        end if;
    end process;

    --______________________________ BRAM Instantiation _______________________    

    dual_port_block_ram_i  :  RAMB16_S36_S36 
    generic map
    (
        INIT_00          =>  MEM_00,
        INIT_01          =>  MEM_01,
        INIT_02          =>  MEM_02,
        INIT_03          =>  MEM_03,
        INIT_04          =>  MEM_04,
        INIT_05          =>  MEM_05,
        INIT_06          =>  MEM_06,
        INIT_07          =>  MEM_07,
        INIT_08          =>  MEM_08,
        INIT_09          =>  MEM_09,
        INIT_0A          =>  MEM_0A,
        INIT_0B          =>  MEM_0B,
        INIT_0C          =>  MEM_0C,
        INIT_0D          =>  MEM_0D,
        INIT_0E          =>  MEM_0E,
        INIT_0F          =>  MEM_0F,
        INIT_10          =>  MEM_10,
        INIT_11          =>  MEM_11,
        INIT_12          =>  MEM_12,
        INIT_13          =>  MEM_13,
        INIT_14          =>  MEM_14,
        INIT_15          =>  MEM_15,
        INIT_16          =>  MEM_16,
        INIT_17          =>  MEM_17,
        INIT_18          =>  MEM_18,
        INIT_19          =>  MEM_19,
        INIT_1A          =>  MEM_1A,
        INIT_1B          =>  MEM_1B,
        INIT_1C          =>  MEM_1C,
        INIT_1D          =>  MEM_1D,
        INIT_1E          =>  MEM_1E,
        INIT_1F          =>  MEM_1F,
        INIT_20          =>  MEM_20,
        INIT_21          =>  MEM_21,
        INIT_22          =>  MEM_22,
        INIT_23          =>  MEM_23,
        INIT_24          =>  MEM_24,
        INIT_25          =>  MEM_25,
        INIT_26          =>  MEM_26,
        INIT_27          =>  MEM_27,
        INIT_28          =>  MEM_28,
        INIT_29          =>  MEM_29,
        INIT_2A          =>  MEM_2A,
        INIT_2B          =>  MEM_2B,
        INIT_2C          =>  MEM_2C,
        INIT_2D          =>  MEM_2D,
        INIT_2E          =>  MEM_2E,
        INIT_2F          =>  MEM_2F,
        INIT_30          =>  MEM_30,
        INIT_31          =>  MEM_31,
        INIT_32          =>  MEM_32,
        INIT_33          =>  MEM_33,
        INIT_34          =>  MEM_34,
        INIT_35          =>  MEM_35,
        INIT_36          =>  MEM_36,
        INIT_37          =>  MEM_37,
        INIT_38          =>  MEM_38,
        INIT_39          =>  MEM_39,
        INIT_3A          =>  MEM_3A,
        INIT_3B          =>  MEM_3B,
        INIT_3C          =>  MEM_3C,
        INIT_3D          =>  MEM_3D,
        INIT_3E          =>  MEM_3E,
        INIT_3F          =>  MEM_3F,
        INITP_00         =>  MEMP_00,
        INITP_01         =>  MEMP_01,
        INITP_02         =>  MEMP_02,
        INITP_03         =>  MEMP_03,
        INITP_04         =>  MEMP_04,
        INITP_05         =>  MEMP_05,
        INITP_06         =>  MEMP_06,
        INITP_07         =>  MEMP_07
    )
    port map 
    (
        ADDRA            =>  std_logic_vector(read_counter_i),
        DIA              =>  tied_to_ground_vec_i(31 downto 0),
        DIPA             =>  tied_to_ground_vec_i(3 downto 0),
        DOA              =>  tx_data_bram_i,
        DOPA             =>  tx_charisk_i, 
        WEA              =>  tied_to_ground_i,
        ENA              =>  tied_to_vcc_i,
        SSRA             =>  tied_to_ground_i, 
        CLKA             =>  USER_CLK,
                         
        ADDRB            =>  tied_to_ground_vec_i(8 downto 0),
        DIB              =>  tied_to_ground_vec_i(31 downto 0),
        DIPB             =>  tied_to_ground_vec_i(3 downto 0),
        DOB              =>  open,  
        DOPB             =>  open, 
        WEB              =>  tied_to_ground_i,
        ENB              =>  tied_to_ground_i,
        SSRB             =>  tied_to_ground_i,
        CLKB             =>  tied_to_ground_i       
    );                   

end RTL;

