------------------------------------------------------------------------------
--   ____  ____
--  /   /\/   /
-- /___/  \  /    Vendor: Xilinx
-- \   \   \/     Version : 1.12
--  \   \         Application : Virtex-6 FPGA GTX Transceiver Wizard 
--  /   /         Filename : v6_gtx_dual_sfp_112_top.vhd
-- /___/   /\      
-- \   \  /  \ 
--  \___\/\___\
--
--
-- Module v6_gtx_dual_sfp_112_top
-- Generated by Xilinx Virtex-6 FPGA GTX Transceiver Wizard
-- 
-- 
-- (c) Copyright 2009-2011 Xilinx, Inc. All rights reserved.
-- 
-- This file contains confidential and proprietary information
-- of Xilinx, Inc. and is protected under U.S. and
-- international copyright and other intellectual property
-- laws.
-- 
-- DISCLAIMER
-- This disclaimer is not a license and does not grant any
-- rights to the materials distributed herewith. Except as
-- otherwise provided in a valid license issued to you by
-- Xilinx, and to the maximum extent permitted by applicable
-- law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
-- WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
-- AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
-- BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
-- INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
-- (2) Xilinx shall not be liable (whether in contract or tort,
-- including negligence, or under any other theory of
-- liability) for any loss or damage of any kind or nature
-- related to, arising under or in connection with these
-- materials, including for any direct, or any indirect,
-- special, incidental, or consequential loss or damage
-- (including loss of data, profits, goodwill, or any type of
-- loss or damage suffered as a result of any action brought
-- by a third party) even if such damage or loss was
-- reasonably foreseeable or Xilinx had been advised of the
-- possibility of the same.
-- 
-- CRITICAL APPLICATIONS
-- Xilinx products are not designed or intended to be fail-
-- safe, or for use in any application requiring fail-safe
-- performance, such as life-support or safety devices or
-- systems, Class III medical devices, nuclear facilities,
-- applications related to the deployment of airbags, or any
-- other applications that could lead to death, personal
-- injury, or severe property or environmental damage
-- (individually and collectively, "Critical
-- Applications"). Customer assumes the sole risk and
-- liability of any use of Xilinx products in Critical
-- Applications, subject only to applicable laws and
-- regulations governing limitations on product liability.
-- 
-- THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
-- PART OF THIS FILE AT ALL TIMES. 


library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;

--***********************************Entity Declaration************************

entity v6_gtx_dual_sfp_112_top is
generic
(
    EXAMPLE_CONFIG_INDEPENDENT_LANES        : integer   := 1;
    EXAMPLE_LANE_WITH_START_CHAR            : integer   := 0;    -- specifies lane with unique start frame ch
    EXAMPLE_WORDS_IN_BRAM                   : integer   := 512;  -- specifies amount of data in BRAM
    EXAMPLE_SIM_GTXRESET_SPEEDUP            : integer   := 1;    -- simulation setting for GTX SecureIP model
    EXAMPLE_USE_CHIPSCOPE                   : integer   := 1     -- Set to 1 to use Chipscope to drive resets
);
port
(
    Q0_CLK0_MGTREFCLK_PAD_N_IN              : in   std_logic;
    Q0_CLK0_MGTREFCLK_PAD_P_IN              : in   std_logic;
    GTXTXRESET_IN                           : in   std_logic;
    GTXRXRESET_IN                           : in   std_logic;
    TRACK_DATA_OUT                          : out  std_logic;
    RXN_IN                                  : in   std_logic_vector(1 downto 0);
    RXP_IN                                  : in   std_logic_vector(1 downto 0);
    TXN_OUT                                 : out  std_logic_vector(1 downto 0);
    TXP_OUT                                 : out  std_logic_vector(1 downto 0)
    
);


end v6_gtx_dual_sfp_112_top;
    
architecture RTL of v6_gtx_dual_sfp_112_top is

--**************************Component Declarations*****************************


component v6_gtx_dual_sfp_112 
generic
(
    -- Simulation attributes
    WRAPPER_SIM_GTXRESET_SPEEDUP    : integer   := 0 -- Set to 1 to speed up sim reset
);
port
(

    --_________________________________________________________________________
    --_________________________________________________________________________
    --GTX0  (X0_Y0)

    ------------------------ Loopback and Powerdown Ports ----------------------
    GTX0_LOOPBACK_IN                        : in   std_logic_vector(2 downto 0);
    ----------------------- Receive Ports - 8b10b Decoder ----------------------
    GTX0_RXCHARISK_OUT                      : out  std_logic;
    GTX0_RXDISPERR_OUT                      : out  std_logic;
    GTX0_RXNOTINTABLE_OUT                   : out  std_logic;
    ------------------- Receive Ports - Clock Correction Ports -----------------
    GTX0_RXCLKCORCNT_OUT                    : out  std_logic_vector(2 downto 0);
    --------------- Receive Ports - Comma Detection and Alignment --------------
    GTX0_RXCOMMADET_OUT                     : out  std_logic;
    GTX0_RXENMCOMMAALIGN_IN                 : in   std_logic;
    GTX0_RXENPCOMMAALIGN_IN                 : in   std_logic;
    ------------------- Receive Ports - RX Data Path interface -----------------
    GTX0_RXDATA_OUT                         : out  std_logic_vector(7 downto 0);
    GTX0_RXRESET_IN                         : in   std_logic;
    GTX0_RXUSRCLK_IN                        : in   std_logic;
    GTX0_RXUSRCLK2_IN                       : in   std_logic;
    ------- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
    GTX0_RXEQMIX_IN                         : in   std_logic_vector(2 downto 0);
    GTX0_RXN_IN                             : in   std_logic;
    GTX0_RXP_IN                             : in   std_logic;
    ------------------------ Receive Ports - RX PLL Ports ----------------------
    GTX0_GREFCLKRX_IN                       : in   std_logic;
    GTX0_GTXRXRESET_IN                      : in   std_logic;
    GTX0_MGTREFCLKRX_IN                     : in   std_logic_vector(1 downto 0);
    GTX0_NORTHREFCLKRX_IN                   : in   std_logic_vector(1 downto 0);
    GTX0_PERFCLKRX_IN                       : in   std_logic;
    GTX0_PLLRXRESET_IN                      : in   std_logic;
    GTX0_RXPLLLKDET_OUT                     : out  std_logic;
    GTX0_RXPLLREFSELDY_IN                   : in   std_logic_vector(2 downto 0);
    GTX0_RXRESETDONE_OUT                    : out  std_logic;
    GTX0_SOUTHREFCLKRX_IN                   : in   std_logic_vector(1 downto 0);
    ----------------- Receive Ports - RX Polarity Control Ports ----------------
    GTX0_RXPOLARITY_IN                      : in   std_logic;
    ---------------- Transmit Ports - 8b10b Encoder Control Ports --------------
    GTX0_TXCHARISK_IN                       : in   std_logic;
    ------------------ Transmit Ports - TX Data Path interface -----------------
    GTX0_TXDATA_IN                          : in   std_logic_vector(7 downto 0);
    GTX0_TXOUTCLK_OUT                       : out  std_logic;
    GTX0_TXRESET_IN                         : in   std_logic;
    GTX0_TXUSRCLK_IN                        : in   std_logic;
    GTX0_TXUSRCLK2_IN                       : in   std_logic;
    ---------------- Transmit Ports - TX Driver and OOB signaling --------------
    GTX0_TXDIFFCTRL_IN                      : in   std_logic_vector(3 downto 0);
    GTX0_TXN_OUT                            : out  std_logic;
    GTX0_TXP_OUT                            : out  std_logic;
    GTX0_TXPOSTEMPHASIS_IN                  : in   std_logic_vector(4 downto 0);
    --------------- Transmit Ports - TX Driver and OOB signalling --------------
    GTX0_TXPREEMPHASIS_IN                   : in   std_logic_vector(3 downto 0);
    ----------------------- Transmit Ports - TX PLL Ports ----------------------
    GTX0_GREFCLKTX_IN                       : in   std_logic;
    GTX0_GTXTXRESET_IN                      : in   std_logic;
    GTX0_NORTHREFCLKTX_IN                   : in   std_logic_vector(1 downto 0);
    GTX0_PERFCLKTX_IN                       : in   std_logic;
    GTX0_SOUTHREFCLKTX_IN                   : in   std_logic_vector(1 downto 0);
    GTX0_TXPLLREFSELDY_IN                   : in   std_logic_vector(2 downto 0);
    GTX0_TXRESETDONE_OUT                    : out  std_logic;
    -------------------- Transmit Ports - TX Polarity Control ------------------
    GTX0_TXPOLARITY_IN                      : in   std_logic;



    --_________________________________________________________________________
    --_________________________________________________________________________
    --GTX1  (X0_Y2)

    ------------------------ Loopback and Powerdown Ports ----------------------
    GTX1_LOOPBACK_IN                        : in   std_logic_vector(2 downto 0);
    ----------------------- Receive Ports - 8b10b Decoder ----------------------
    GTX1_RXCHARISK_OUT                      : out  std_logic;
    GTX1_RXDISPERR_OUT                      : out  std_logic;
    GTX1_RXNOTINTABLE_OUT                   : out  std_logic;
    ------------------- Receive Ports - Clock Correction Ports -----------------
    GTX1_RXCLKCORCNT_OUT                    : out  std_logic_vector(2 downto 0);
    --------------- Receive Ports - Comma Detection and Alignment --------------
    GTX1_RXCOMMADET_OUT                     : out  std_logic;
    GTX1_RXENMCOMMAALIGN_IN                 : in   std_logic;
    GTX1_RXENPCOMMAALIGN_IN                 : in   std_logic;
    ------------------- Receive Ports - RX Data Path interface -----------------
    GTX1_RXDATA_OUT                         : out  std_logic_vector(7 downto 0);
    GTX1_RXRESET_IN                         : in   std_logic;
    GTX1_RXUSRCLK_IN                        : in   std_logic;
    GTX1_RXUSRCLK2_IN                       : in   std_logic;
    ------- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
    GTX1_RXEQMIX_IN                         : in   std_logic_vector(2 downto 0);
    GTX1_RXN_IN                             : in   std_logic;
    GTX1_RXP_IN                             : in   std_logic;
    ------------------------ Receive Ports - RX PLL Ports ----------------------
    GTX1_GREFCLKRX_IN                       : in   std_logic;
    GTX1_GTXRXRESET_IN                      : in   std_logic;
    GTX1_MGTREFCLKRX_IN                     : in   std_logic_vector(1 downto 0);
    GTX1_NORTHREFCLKRX_IN                   : in   std_logic_vector(1 downto 0);
    GTX1_PERFCLKRX_IN                       : in   std_logic;
    GTX1_PLLRXRESET_IN                      : in   std_logic;
    GTX1_RXPLLLKDET_OUT                     : out  std_logic;
    GTX1_RXPLLREFSELDY_IN                   : in   std_logic_vector(2 downto 0);
    GTX1_RXRESETDONE_OUT                    : out  std_logic;
    GTX1_SOUTHREFCLKRX_IN                   : in   std_logic_vector(1 downto 0);
    ----------------- Receive Ports - RX Polarity Control Ports ----------------
    GTX1_RXPOLARITY_IN                      : in   std_logic;
    ---------------- Transmit Ports - 8b10b Encoder Control Ports --------------
    GTX1_TXCHARISK_IN                       : in   std_logic;
    ------------------ Transmit Ports - TX Data Path interface -----------------
    GTX1_TXDATA_IN                          : in   std_logic_vector(7 downto 0);
    GTX1_TXOUTCLK_OUT                       : out  std_logic;
    GTX1_TXRESET_IN                         : in   std_logic;
    GTX1_TXUSRCLK_IN                        : in   std_logic;
    GTX1_TXUSRCLK2_IN                       : in   std_logic;
    ---------------- Transmit Ports - TX Driver and OOB signaling --------------
    GTX1_TXDIFFCTRL_IN                      : in   std_logic_vector(3 downto 0);
    GTX1_TXN_OUT                            : out  std_logic;
    GTX1_TXP_OUT                            : out  std_logic;
    GTX1_TXPOSTEMPHASIS_IN                  : in   std_logic_vector(4 downto 0);
    --------------- Transmit Ports - TX Driver and OOB signalling --------------
    GTX1_TXPREEMPHASIS_IN                   : in   std_logic_vector(3 downto 0);
    ----------------------- Transmit Ports - TX PLL Ports ----------------------
    GTX1_GREFCLKTX_IN                       : in   std_logic;
    GTX1_GTXTXRESET_IN                      : in   std_logic;
    GTX1_NORTHREFCLKTX_IN                   : in   std_logic_vector(1 downto 0);
    GTX1_PERFCLKTX_IN                       : in   std_logic;
    GTX1_SOUTHREFCLKTX_IN                   : in   std_logic_vector(1 downto 0);
    GTX1_TXPLLREFSELDY_IN                   : in   std_logic_vector(2 downto 0);
    GTX1_TXRESETDONE_OUT                    : out  std_logic;
    -------------------- Transmit Ports - TX Polarity Control ------------------
    GTX1_TXPOLARITY_IN                      : in   std_logic


);
end component;

component MGT_USRCLK_SOURCE 
generic
(
    FREQUENCY_MODE   : string   := "LOW";    
    PERFORMANCE_MODE : string   := "MAX_SPEED"    
);
port
(
    DIV1_OUT                : out std_logic;
    DIV2_OUT                : out std_logic;
    DCM_LOCKED_OUT          : out std_logic;
    CLK_IN                  : in  std_logic;
    DCM_RESET_IN            : in  std_logic

);
end component;

component FRAME_GEN 
generic
(
    WORDS_IN_BRAM : integer    :=   256;
    MEM_00       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_01       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_02       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_03       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_04       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_05       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_06       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_07       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_08       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_09       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_0A       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_0B       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_0C       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_0D       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_0E       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_0F       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_10       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_11       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_12       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_13       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_14       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_15       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_16       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_17       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_18       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_19       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_1A       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_1B       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_1C       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_1D       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_1E       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_1F       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_20       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_21       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_22       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_23       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_24       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_25       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_26       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_27       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_28       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_29       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_2A       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_2B       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_2C       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_2D       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_2E       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_2F       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_30       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_31       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_32       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_33       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_34       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_35       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_36       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_37       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_38       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_39       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_3A       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_3B       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_3C       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_3D       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_3E       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_3F       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEMP_00      : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEMP_01      : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEMP_02      : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEMP_03      : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEMP_04      : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEMP_05      : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEMP_06      : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEMP_07      : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000"
);    
port
(
    -- User Interface
    TX_DATA             : out   std_logic_vector(39 downto 0);
    TX_CHARISK          : out   std_logic_vector(3 downto 0); 

    -- System Interface
    USER_CLK            : in    std_logic;
    SYSTEM_RESET        : in    std_logic
); 
end component;

component FRAME_CHECK 
generic
(
    RX_DATA_WIDTH            : integer := 16;
    RXCTRL_WIDTH             : integer := 2;
    USE_COMMA                : integer := 1;
    NONE_MSB_FIRST_DEC       : integer := 0;
    COMMA_DOUBLE_DEC         : integer := 0;
    CHANBOND_SEQ_LEN         : integer := 1;
    WORDS_IN_BRAM            : integer := 256;
    CONFIG_INDEPENDENT_LANES : integer := 0;
    START_OF_PACKET_CHAR     : std_logic_vector(15 downto 0) ;
    COMMA_DOUBLE_CHAR        : std_logic_vector(15 downto 0) := x"f628";
    MEM_00       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_01       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_02       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_03       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_04       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_05       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_06       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_07       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_08       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_09       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_0A       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_0B       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_0C       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_0D       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_0E       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_0F       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_10       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_11       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_12       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_13       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_14       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_15       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_16       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_17       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_18       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_19       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_1A       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_1B       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_1C       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_1D       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_1E       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_1F       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_20       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_21       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_22       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_23       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_24       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_25       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_26       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_27       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_28       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_29       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_2A       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_2B       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_2C       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_2D       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_2E       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_2F       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_30       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_31       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_32       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_33       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_34       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_35       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_36       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_37       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_38       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_39       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_3A       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_3B       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_3C       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_3D       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_3E       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEM_3F       : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEMP_00      : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEMP_01      : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEMP_02      : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEMP_03      : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEMP_04      : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEMP_05      : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEMP_06      : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000";
    MEMP_07      : bit_vector :=   X"0000000000000000000000000000000000000000000000000000000000000000"
);
port
(
    -- User Interface
    RX_DATA                  : in  std_logic_vector((RX_DATA_WIDTH-1) downto 0);
 
    RXCTRL_IN                : in  std_logic_vector((RXCTRL_WIDTH-1) downto 0);  
    RX_ENMCOMMA_ALIGN        : out std_logic;
    RX_ENPCOMMA_ALIGN        : out std_logic;
 
    RX_ENCHAN_SYNC           : out std_logic; 
    RX_CHANBOND_SEQ          : in  std_logic; 

    -- Control Interface
    INC_IN                   : in std_logic; 
    INC_OUT                  : out std_logic; 
    PATTERN_MATCH_N          : out std_logic;
    RESET_ON_ERROR           : in std_logic; 
    
    -- Error Monitoring
    ERROR_COUNT              : out std_logic_vector(7 downto 0);
    
    -- Track Data
    TRACK_DATA               : out std_logic;
 
    -- System Interface
    USER_CLK                 : in std_logic;
    SYSTEM_RESET             : in std_logic
  
);
end component;

component MGT_USRCLK_SOURCE_MMCM
generic
(
    MULT                 : real             := 2.0;
    DIVIDE               : integer          := 2;    
    CLK_PERIOD           : real             := 6.4;    
    OUT0_DIVIDE          : real             := 2.0;
    OUT1_DIVIDE          : integer          := 2;
    OUT2_DIVIDE          : integer          := 2;
    OUT3_DIVIDE          : integer          := 2
);
port
(
    CLKFBOUT                : out std_logic; 
    CLK0_OUT                : out std_logic;
    CLK1_OUT                : out std_logic;
    CLK2_OUT                : out std_logic;
    CLK3_OUT                : out std_logic;
    CLK_IN                  : in  std_logic;
    MMCM_LOCKED_OUT         : out std_logic;
    MMCM_RESET_IN           : in  std_logic
);
end component;



-- Chipscope modules
attribute syn_black_box                : boolean;
attribute syn_noprune                  : boolean;


component data_vio
port
(
    control                 : inout std_logic_vector(35 downto 0);
    clk                     : in    std_logic;
    async_in                : in    std_logic_vector(31 downto 0);
    async_out               : out   std_logic_vector(31 downto 0);
    sync_in                 : in    std_logic_vector(31 downto 0);
    sync_out                : out   std_logic_vector(31 downto 0)
);
end component;
attribute syn_black_box of data_vio : component is TRUE;
attribute syn_noprune of data_vio   : component is TRUE;


component icon
port
(
    control0                : inout std_logic_vector(35 downto 0);
    control1                : inout std_logic_vector(35 downto 0);
    control2                : inout std_logic_vector(35 downto 0);
    control3                : inout std_logic_vector(35 downto 0)
);
end component;
attribute syn_black_box of icon : component is TRUE;
attribute syn_noprune of icon   : component is TRUE;


component ila
port
(
    control                 : inout std_logic_vector(35 downto 0);
    clk                     : in    std_logic;
    trig0                   : in    std_logic_vector(84 downto 0)
);
end component;


attribute syn_black_box of ila : component is TRUE;
attribute syn_noprune of ila   : component is TRUE;


--***********************************Parameter Declarations********************

    constant DLY : time := 1 ns;
 
    attribute max_fanout : string; 

--************************** Register Declarations ****************************

    signal   gtx0_txresetdone_r              : std_logic;
    signal   gtx0_txresetdone_r2             : std_logic;
    signal   gtx0_rxresetdone_i_r            : std_logic;
    signal   gtx0_rxresetdone_r              : std_logic;
    signal   gtx0_rxresetdone_r2             : std_logic;
    signal   gtx0_rxresetdone_r3             : std_logic;
    attribute max_fanout of gtx0_rxresetdone_i_r : signal is "1";
    signal   gtx0_rxdata_r                   : std_logic_vector(7 downto 0);
    signal   gtx0_rxcharisk_r                : std_logic_vector(0 downto 0);    
    signal   gtx1_txresetdone_r              : std_logic;
    signal   gtx1_txresetdone_r2             : std_logic;
    signal   gtx1_rxresetdone_i_r            : std_logic;
    signal   gtx1_rxresetdone_r              : std_logic;
    signal   gtx1_rxresetdone_r2             : std_logic;
    signal   gtx1_rxresetdone_r3             : std_logic;
    attribute max_fanout of gtx1_rxresetdone_i_r : signal is "1";
    signal   gtx1_rxdata_r                   : std_logic_vector(7 downto 0);
    signal   gtx1_rxcharisk_r                : std_logic_vector(0 downto 0);    


--**************************** Wire Declarations ******************************
    -------------------------- MGT Wrapper Wires ------------------------------
    --________________________________________________________________________
    --________________________________________________________________________
    --GTX0   (X0Y0)

    ------------------------ Loopback and Powerdown Ports ----------------------
    signal  gtx0_loopback_i                 : std_logic_vector(2 downto 0);
    ----------------------- Receive Ports - 8b10b Decoder ----------------------
    signal  gtx0_rxcharisk_i                : std_logic;
    signal  gtx0_rxdisperr_i                : std_logic;
    signal  gtx0_rxnotintable_i             : std_logic;
    ------------------- Receive Ports - Clock Correction Ports -----------------
    signal  gtx0_rxclkcorcnt_i              : std_logic_vector(2 downto 0);
    --------------- Receive Ports - Comma Detection and Alignment --------------
    signal  gtx0_rxcommadet_i               : std_logic;
    signal  gtx0_rxenmcommaalign_i          : std_logic;
    signal  gtx0_rxenpcommaalign_i          : std_logic;
    ------------------- Receive Ports - RX Data Path interface -----------------
    signal  gtx0_rxdata_i                   : std_logic_vector(7 downto 0);
    signal  gtx0_rxreset_i                  : std_logic;
    ------- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
    signal  gtx0_rxeqmix_i                  : std_logic_vector(2 downto 0);
    ------------------------ Receive Ports - RX PLL Ports ----------------------
    signal  gtx0_grefclkrx_i                : std_logic;
    signal  gtx0_gtxrxreset_i               : std_logic;
    signal  gtx0_northrefclkrx_i            : std_logic_vector(1 downto 0);
    signal  gtx0_perfclkrx_i                : std_logic;
    signal  gtx0_pllrxreset_i               : std_logic;
    signal  gtx0_rxplllkdet_i               : std_logic;
    signal  gtx0_rxpllrefseldy_i            : std_logic_vector(2 downto 0);
    signal  gtx0_rxresetdone_i              : std_logic;
    signal  gtx0_southrefclkrx_i            : std_logic_vector(1 downto 0);
    ----------------- Receive Ports - RX Polarity Control Ports ----------------
    signal  gtx0_rxpolarity_i               : std_logic;
    ---------------- Transmit Ports - 8b10b Encoder Control Ports --------------
    signal  gtx0_txcharisk_i                : std_logic;
    ------------------ Transmit Ports - TX Data Path interface -----------------
    signal  gtx0_txdata_i                   : std_logic_vector(7 downto 0);
    signal  gtx0_txoutclk_i                 : std_logic;
    signal  gtx0_txreset_i                  : std_logic;
    ---------------- Transmit Ports - TX Driver and OOB signaling --------------
    signal  gtx0_txdiffctrl_i               : std_logic_vector(3 downto 0);
    signal  gtx0_txpostemphasis_i           : std_logic_vector(4 downto 0);
    --------------- Transmit Ports - TX Driver and OOB signalling --------------
    signal  gtx0_txpreemphasis_i            : std_logic_vector(3 downto 0);
    ----------------------- Transmit Ports - TX PLL Ports ----------------------
    signal  gtx0_grefclktx_i                : std_logic;
    signal  gtx0_gtxtxreset_i               : std_logic;
    signal  gtx0_northrefclktx_i            : std_logic_vector(1 downto 0);
    signal  gtx0_perfclktx_i                : std_logic;
    signal  gtx0_southrefclktx_i            : std_logic_vector(1 downto 0);
    signal  gtx0_txpllrefseldy_i            : std_logic_vector(2 downto 0);
    signal  gtx0_txresetdone_i              : std_logic;
    -------------------- Transmit Ports - TX Polarity Control ------------------
    signal  gtx0_txpolarity_i               : std_logic;


    --________________________________________________________________________
    --________________________________________________________________________
    --GTX1   (X0Y2)

    ------------------------ Loopback and Powerdown Ports ----------------------
    signal  gtx1_loopback_i                 : std_logic_vector(2 downto 0);
    ----------------------- Receive Ports - 8b10b Decoder ----------------------
    signal  gtx1_rxcharisk_i                : std_logic;
    signal  gtx1_rxdisperr_i                : std_logic;
    signal  gtx1_rxnotintable_i             : std_logic;
    ------------------- Receive Ports - Clock Correction Ports -----------------
    signal  gtx1_rxclkcorcnt_i              : std_logic_vector(2 downto 0);
    --------------- Receive Ports - Comma Detection and Alignment --------------
    signal  gtx1_rxcommadet_i               : std_logic;
    signal  gtx1_rxenmcommaalign_i          : std_logic;
    signal  gtx1_rxenpcommaalign_i          : std_logic;
    ------------------- Receive Ports - RX Data Path interface -----------------
    signal  gtx1_rxdata_i                   : std_logic_vector(7 downto 0);
    signal  gtx1_rxreset_i                  : std_logic;
    ------- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
    signal  gtx1_rxeqmix_i                  : std_logic_vector(2 downto 0);
    ------------------------ Receive Ports - RX PLL Ports ----------------------
    signal  gtx1_grefclkrx_i                : std_logic;
    signal  gtx1_gtxrxreset_i               : std_logic;
    signal  gtx1_northrefclkrx_i            : std_logic_vector(1 downto 0);
    signal  gtx1_perfclkrx_i                : std_logic;
    signal  gtx1_pllrxreset_i               : std_logic;
    signal  gtx1_rxplllkdet_i               : std_logic;
    signal  gtx1_rxpllrefseldy_i            : std_logic_vector(2 downto 0);
    signal  gtx1_rxresetdone_i              : std_logic;
    signal  gtx1_southrefclkrx_i            : std_logic_vector(1 downto 0);
    ----------------- Receive Ports - RX Polarity Control Ports ----------------
    signal  gtx1_rxpolarity_i               : std_logic;
    ---------------- Transmit Ports - 8b10b Encoder Control Ports --------------
    signal  gtx1_txcharisk_i                : std_logic;
    ------------------ Transmit Ports - TX Data Path interface -----------------
    signal  gtx1_txdata_i                   : std_logic_vector(7 downto 0);
    signal  gtx1_txoutclk_i                 : std_logic;
    signal  gtx1_txreset_i                  : std_logic;
    ---------------- Transmit Ports - TX Driver and OOB signaling --------------
    signal  gtx1_txdiffctrl_i               : std_logic_vector(3 downto 0);
    signal  gtx1_txpostemphasis_i           : std_logic_vector(4 downto 0);
    --------------- Transmit Ports - TX Driver and OOB signalling --------------
    signal  gtx1_txpreemphasis_i            : std_logic_vector(3 downto 0);
    ----------------------- Transmit Ports - TX PLL Ports ----------------------
    signal  gtx1_grefclktx_i                : std_logic;
    signal  gtx1_gtxtxreset_i               : std_logic;
    signal  gtx1_northrefclktx_i            : std_logic_vector(1 downto 0);
    signal  gtx1_perfclktx_i                : std_logic;
    signal  gtx1_southrefclktx_i            : std_logic_vector(1 downto 0);
    signal  gtx1_txpllrefseldy_i            : std_logic_vector(2 downto 0);
    signal  gtx1_txresetdone_i              : std_logic;
    -------------------- Transmit Ports - TX Polarity Control ------------------
    signal  gtx1_txpolarity_i               : std_logic;




    signal  gtx0_tx_system_reset_c          : std_logic;
    signal  gtx0_rx_system_reset_c          : std_logic;
    signal  gtx1_tx_system_reset_c          : std_logic;
    signal  gtx1_rx_system_reset_c          : std_logic;
    signal  tied_to_ground_i                : std_logic;
    signal  tied_to_ground_vec_i            : std_logic_vector(63 downto 0);
    signal  tied_to_vcc_i                   : std_logic;
    signal  tied_to_vcc_vec_i               : std_logic_vector(7 downto 0);
    signal  drp_clk_in_i                    : std_logic;
 

    ----------------------------- User Clocks ---------------------------------

    signal  gtx0_txusrclk_i                 : std_logic;
    signal  gtx0_txusrclk2_i                : std_logic;
    signal  txoutclk_mmcm0_locked_i         : std_logic;
    signal  txoutclk_mmcm0_reset_i          : std_logic;
    signal  gtx0_txoutclk_to_mmcm_i         : std_logic;


    ----------------------------- Reference Clocks ----------------------------
    
    signal    q0_clk0_refclk_i                : std_logic;
    signal    q0_clk0_refclk_i_bufg           : std_logic;

    ----------------------- Frame check/gen Module Signals --------------------
    
    signal    gtx0_matchn_i                   : std_logic;
    
    signal    gtx0_txcharisk_float_i          : std_logic_vector(2 downto 0);
    
    signal    gtx0_txdata_float_i             : std_logic_vector(31 downto 0);
    
    signal    gtx0_track_data_i               : std_logic;
    signal    gtx0_block_sync_i               : std_logic;
    signal    gtx0_error_count_i              : std_logic_vector(7 downto 0);
    signal    gtx0_frame_check_reset_i        : std_logic;
    signal    gtx0_inc_in_i                   : std_logic;
    signal    gtx0_inc_out_i                  : std_logic;
    signal    gtx0_unscrambled_data_i         : std_logic_vector(7 downto 0);

    signal    gtx1_matchn_i                   : std_logic;
    
    signal    gtx1_txcharisk_float_i          : std_logic_vector(2 downto 0);
    
    signal    gtx1_txdata_float_i             : std_logic_vector(31 downto 0);
    
    signal    gtx1_track_data_i               : std_logic;
    signal    gtx1_block_sync_i               : std_logic;
    signal    gtx1_error_count_i              : std_logic_vector(7 downto 0);
    signal    gtx1_frame_check_reset_i        : std_logic;
    signal    gtx1_inc_in_i                   : std_logic;
    signal    gtx1_inc_out_i                  : std_logic;
    signal    gtx1_unscrambled_data_i         : std_logic_vector(7 downto 0);

    signal    reset_on_data_error_i           : std_logic;
    signal    track_data_out_i                : std_logic;
 
    

    ----------------------- Chipscope Signals ---------------------------------

    signal  tx_data_vio_control_i           : std_logic_vector(35 downto 0);
    signal  rx_data_vio_control_i           : std_logic_vector(35 downto 0);
    signal  shared_vio_control_i            : std_logic_vector(35 downto 0);
    signal  ila_control_i                   : std_logic_vector(35 downto 0);
    signal  tx_data_vio_async_in_i          : std_logic_vector(31 downto 0);
    signal  tx_data_vio_sync_in_i           : std_logic_vector(31 downto 0);
    signal  tx_data_vio_async_out_i         : std_logic_vector(31 downto 0);
    signal  tx_data_vio_sync_out_i          : std_logic_vector(31 downto 0);
    signal  rx_data_vio_async_in_i          : std_logic_vector(31 downto 0);
    signal  rx_data_vio_sync_in_i           : std_logic_vector(31 downto 0);
    signal  rx_data_vio_async_out_i         : std_logic_vector(31 downto 0);
    signal  rx_data_vio_sync_out_i          : std_logic_vector(31 downto 0);
    signal  shared_vio_in_i                 : std_logic_vector(31 downto 0);
    signal  shared_vio_out_i                : std_logic_vector(31 downto 0);
    signal  ila_in_i                        : std_logic_vector(84 downto 0);

    signal  gtx0_tx_data_vio_async_in_i     : std_logic_vector(31 downto 0);
    signal  gtx0_tx_data_vio_sync_in_i      : std_logic_vector(31 downto 0);
    signal  gtx0_tx_data_vio_async_out_i    : std_logic_vector(31 downto 0);
    signal  gtx0_tx_data_vio_sync_out_i     : std_logic_vector(31 downto 0);
    signal  gtx0_rx_data_vio_async_in_i     : std_logic_vector(31 downto 0);
    signal  gtx0_rx_data_vio_sync_in_i      : std_logic_vector(31 downto 0);
    signal  gtx0_rx_data_vio_async_out_i    : std_logic_vector(31 downto 0);
    signal  gtx0_rx_data_vio_sync_out_i     : std_logic_vector(31 downto 0);
    signal  gtx0_ila_in_i                   : std_logic_vector(84 downto 0);

    signal  gtx1_tx_data_vio_async_in_i     : std_logic_vector(31 downto 0);
    signal  gtx1_tx_data_vio_sync_in_i      : std_logic_vector(31 downto 0);
    signal  gtx1_tx_data_vio_async_out_i    : std_logic_vector(31 downto 0);
    signal  gtx1_tx_data_vio_sync_out_i     : std_logic_vector(31 downto 0);
    signal  gtx1_rx_data_vio_async_in_i     : std_logic_vector(31 downto 0);
    signal  gtx1_rx_data_vio_sync_in_i      : std_logic_vector(31 downto 0);
    signal  gtx1_rx_data_vio_async_out_i    : std_logic_vector(31 downto 0);
    signal  gtx1_rx_data_vio_sync_out_i     : std_logic_vector(31 downto 0);
    signal  gtx1_ila_in_i                   : std_logic_vector(84 downto 0);


    signal    gtxtxreset_i                    : std_logic;
    signal    gtxrxreset_i                    : std_logic;
    signal    mux_sel_i                       : std_logic;

    signal    user_tx_reset_i                 : std_logic;
    signal    user_rx_reset_i                 : std_logic;
    signal    tx_vio_clk_i                    : std_logic;
    signal    tx_vio_clk_mux_out_i            : std_logic;
    signal    rx_vio_ila_clk_i                : std_logic;
    signal    rx_vio_ila_clk_mux_out_i        : std_logic;


    signal    q0_clk0_refclk_i_i : std_logic_vector(1 downto 0);
    
--**************************** Main Body of Code *******************************
begin

    --  Static signal Assigments
    tied_to_ground_i                             <= '0';
    tied_to_ground_vec_i                         <= x"0000000000000000";
    tied_to_vcc_i                                <= '1';
    tied_to_vcc_vec_i                            <= x"ff";

    gtx0_grefclktx_i             <= tied_to_ground_i;
    gtx0_grefclkrx_i             <= tied_to_ground_i;
    gtx0_perfclktx_i             <= tied_to_ground_i;
    gtx0_perfclkrx_i             <= tied_to_ground_i;
    gtx0_northrefclktx_i         <= tied_to_ground_vec_i(1 downto 0);
    gtx0_northrefclkrx_i         <= tied_to_ground_vec_i(1 downto 0);
    gtx0_southrefclktx_i         <= tied_to_ground_vec_i(1 downto 0);
    gtx0_southrefclkrx_i         <= tied_to_ground_vec_i(1 downto 0);
    gtx1_grefclktx_i             <= tied_to_ground_i;
    gtx1_grefclkrx_i             <= tied_to_ground_i;
    gtx1_perfclktx_i             <= tied_to_ground_i;
    gtx1_perfclkrx_i             <= tied_to_ground_i;
    gtx1_northrefclktx_i         <= tied_to_ground_vec_i(1 downto 0);
    gtx1_northrefclkrx_i         <= tied_to_ground_vec_i(1 downto 0);
    gtx1_southrefclktx_i         <= tied_to_ground_vec_i(1 downto 0);
    gtx1_southrefclkrx_i         <= tied_to_ground_vec_i(1 downto 0);


    
  
    
  

    -----------------------Dedicated GTX Reference Clock Inputs ---------------
    -- The dedicated reference clock inputs you selected in the GUI are implemented using
    -- IBUFDS_GTXE1 instances.
    --
    -- In the UCF file for this example design, you will see that each of
    -- these IBUFDS_GTXE1 instances has been LOCed to a particular set of pins. By LOCing to these
    -- locations, we tell the tools to use the dedicated input buffers to the GTX reference
    -- clock network, rather than general purpose IOs. To select other pins, consult the 
    -- Implementation chapter of UG___, or rerun the wizard.
    --
    -- This network is the highest performace (lowest jitter) option for providing clocks
    -- to the GTX transceivers.
    
    q0_clk0_refclk_ibufds_i : IBUFDS_GTXE1
    port map
    (
        O                               =>      q0_clk0_refclk_i,
        ODIV2                           =>      open,
        CEB                             =>      tied_to_ground_i,
        I                               =>      Q0_CLK0_MGTREFCLK_PAD_P_IN,
        IB                              =>      Q0_CLK0_MGTREFCLK_PAD_N_IN
    );

    q0_clk0_refclk_i_i <= ('0' & q0_clk0_refclk_i);
 

   q0_clk0_refclk_bufg_i : BUFG
    port map
    (
        I                               =>      q0_clk0_refclk_i,
        O                               =>      q0_clk0_refclk_i_bufg
    );



    ----------------------------------- User Clocks ---------------------------
    
    -- The clock resources in this section were added based on userclk source selections on
    -- the Latency, Buffering, and Clocking page of the GUI. A few notes about user clocks:
    -- * The userclk and userclk2 for each GTX datapath (TX and RX) must be phase aligned to 
    --   avoid data errors in the fabric interface whenever the datapath is wider than 10 bits
    -- * To minimize clock resources, you can share clocks between GTXs. GTXs using the same frequency
    --   or multiples of the same frequency can be accomadated using MMCMs. Use caution when
    --   using RXRECCLK as a clock source, however - these clocks can typically only be shared if all
    --   the channels using the clock are receiving data from TX channels that share a reference clock 
    --   source with each other.

    txoutclk_mmcm0_reset_i                       <= not gtx0_rxplllkdet_i;
    txoutclk_mmcm0_i : MGT_USRCLK_SOURCE_MMCM
    generic map
    (
        MULT                            =>      8.0,
        DIVIDE                          =>      2,
        CLK_PERIOD                      =>      4.0,
        OUT0_DIVIDE                     =>      8.0,
        OUT1_DIVIDE                     =>      4,
        OUT2_DIVIDE                     =>      1,
        OUT3_DIVIDE                     =>      1
    )
    port map
    (
        CLKFBOUT                        =>      gtx0_txusrclk_i,
        CLK0_OUT                        =>      open,
        CLK1_OUT                        =>      gtx0_txusrclk2_i,
        CLK2_OUT                        =>      open,
        CLK3_OUT                        =>      open,
        CLK_IN                          =>      gtx0_txoutclk_i,
        MMCM_LOCKED_OUT                 =>      txoutclk_mmcm0_locked_i,
        MMCM_RESET_IN                   =>      txoutclk_mmcm0_reset_i
    );




    ----------------------------- The GTX Wrapper -----------------------------
    
    -- Use the instantiation template in the example directory to add the GTX wrapper to your design.
    -- In this example, the wrapper is wired up for basic operation with a frame generator and frame 
    -- checker. The GTXs will reset, then attempt to align and transmit data. If channel bonding is 
    -- enabled, bonding should occur after alignment.


    v6_gtx_dual_sfp_112_i : v6_gtx_dual_sfp_112
    generic map
    (
        WRAPPER_SIM_GTXRESET_SPEEDUP    =>      EXAMPLE_SIM_GTXRESET_SPEEDUP
    )
    port map
    (
  
 
 
 

        --_____________________________________________________________________
        --_____________________________________________________________________
        --GTX0  (X0Y0)
        ------------------------ Loopback and Powerdown Ports ----------------------
        GTX0_LOOPBACK_IN                =>      gtx0_loopback_i,
        ----------------------- Receive Ports - 8b10b Decoder ----------------------
        GTX0_RXCHARISK_OUT              =>      gtx0_rxcharisk_i,
        GTX0_RXDISPERR_OUT              =>      gtx0_rxdisperr_i,
        GTX0_RXNOTINTABLE_OUT           =>      gtx0_rxnotintable_i,
        ------------------- Receive Ports - Clock Correction Ports -----------------
        GTX0_RXCLKCORCNT_OUT            =>      gtx0_rxclkcorcnt_i,
        --------------- Receive Ports - Comma Detection and Alignment --------------
        GTX0_RXCOMMADET_OUT             =>      gtx0_rxcommadet_i,
        GTX0_RXENMCOMMAALIGN_IN         =>      gtx0_rxenmcommaalign_i,
        GTX0_RXENPCOMMAALIGN_IN         =>      gtx0_rxenpcommaalign_i,
        ------------------- Receive Ports - RX Data Path interface -----------------
        GTX0_RXDATA_OUT                 =>      gtx0_rxdata_i,
        GTX0_RXRESET_IN                 =>      gtx0_rxreset_i,
        GTX0_RXUSRCLK_IN                =>      gtx0_txusrclk_i,
        GTX0_RXUSRCLK2_IN               =>      gtx0_txusrclk2_i,
        ------- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
        GTX0_RXEQMIX_IN                 =>      gtx0_rxeqmix_i,
        GTX0_RXN_IN                     =>      RXN_IN(0),
        GTX0_RXP_IN                     =>      RXP_IN(0),
        ------------------------ Receive Ports - RX PLL Ports ----------------------
        GTX0_GREFCLKRX_IN               =>      gtx0_grefclkrx_i,
        GTX0_GTXRXRESET_IN              =>      gtx0_gtxrxreset_i,
        GTX0_MGTREFCLKRX_IN             =>      q0_clk0_refclk_i_i,
        GTX0_NORTHREFCLKRX_IN           =>      gtx0_northrefclkrx_i,
        GTX0_PERFCLKRX_IN               =>      gtx0_perfclkrx_i,
        GTX0_PLLRXRESET_IN              =>      gtx0_pllrxreset_i,
        GTX0_RXPLLLKDET_OUT             =>      gtx0_rxplllkdet_i,
        GTX0_RXPLLREFSELDY_IN           =>      gtx0_rxpllrefseldy_i,
        GTX0_RXRESETDONE_OUT            =>      gtx0_rxresetdone_i,
        GTX0_SOUTHREFCLKRX_IN           =>      gtx0_southrefclkrx_i,
        ----------------- Receive Ports - RX Polarity Control Ports ----------------
        GTX0_RXPOLARITY_IN              =>      gtx0_rxpolarity_i,
        ---------------- Transmit Ports - 8b10b Encoder Control Ports --------------
        GTX0_TXCHARISK_IN               =>      gtx0_txcharisk_i,
        ------------------ Transmit Ports - TX Data Path interface -----------------
        GTX0_TXDATA_IN                  =>      gtx0_txdata_i,
        GTX0_TXOUTCLK_OUT               =>      gtx0_txoutclk_i,
        GTX0_TXRESET_IN                 =>      gtx0_txreset_i,
        GTX0_TXUSRCLK_IN                =>      gtx0_txusrclk_i,
        GTX0_TXUSRCLK2_IN               =>      gtx0_txusrclk2_i,
        ---------------- Transmit Ports - TX Driver and OOB signaling --------------
        GTX0_TXDIFFCTRL_IN              =>      gtx0_txdiffctrl_i,
        GTX0_TXN_OUT                    =>      TXN_OUT(0),
        GTX0_TXP_OUT                    =>      TXP_OUT(0),
        GTX0_TXPOSTEMPHASIS_IN          =>      gtx0_txpostemphasis_i,
        --------------- Transmit Ports - TX Driver and OOB signalling --------------
        GTX0_TXPREEMPHASIS_IN           =>      gtx0_txpreemphasis_i,
        ----------------------- Transmit Ports - TX PLL Ports ----------------------
        GTX0_GREFCLKTX_IN               =>      gtx0_grefclktx_i,
        GTX0_GTXTXRESET_IN              =>      gtx0_gtxtxreset_i,
        GTX0_NORTHREFCLKTX_IN           =>      gtx0_northrefclktx_i,
        GTX0_PERFCLKTX_IN               =>      gtx0_perfclktx_i,
        GTX0_SOUTHREFCLKTX_IN           =>      gtx0_southrefclktx_i,
        GTX0_TXPLLREFSELDY_IN           =>      gtx0_txpllrefseldy_i,
        GTX0_TXRESETDONE_OUT            =>      gtx0_txresetdone_i,
        -------------------- Transmit Ports - TX Polarity Control ------------------
        GTX0_TXPOLARITY_IN              =>      gtx0_txpolarity_i,


  
 
 
 

        --_____________________________________________________________________
        --_____________________________________________________________________
        --GTX1  (X0Y2)
        ------------------------ Loopback and Powerdown Ports ----------------------
        GTX1_LOOPBACK_IN                =>      gtx1_loopback_i,
        ----------------------- Receive Ports - 8b10b Decoder ----------------------
        GTX1_RXCHARISK_OUT              =>      gtx1_rxcharisk_i,
        GTX1_RXDISPERR_OUT              =>      gtx1_rxdisperr_i,
        GTX1_RXNOTINTABLE_OUT           =>      gtx1_rxnotintable_i,
        ------------------- Receive Ports - Clock Correction Ports -----------------
        GTX1_RXCLKCORCNT_OUT            =>      gtx1_rxclkcorcnt_i,
        --------------- Receive Ports - Comma Detection and Alignment --------------
        GTX1_RXCOMMADET_OUT             =>      gtx1_rxcommadet_i,
        GTX1_RXENMCOMMAALIGN_IN         =>      gtx1_rxenmcommaalign_i,
        GTX1_RXENPCOMMAALIGN_IN         =>      gtx1_rxenpcommaalign_i,
        ------------------- Receive Ports - RX Data Path interface -----------------
        GTX1_RXDATA_OUT                 =>      gtx1_rxdata_i,
        GTX1_RXRESET_IN                 =>      gtx1_rxreset_i,
        GTX1_RXUSRCLK_IN                =>      gtx0_txusrclk_i,
        GTX1_RXUSRCLK2_IN               =>      gtx0_txusrclk2_i,
        ------- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
        GTX1_RXEQMIX_IN                 =>      gtx1_rxeqmix_i,
        GTX1_RXN_IN                     =>      RXN_IN(1),
        GTX1_RXP_IN                     =>      RXP_IN(1),
        ------------------------ Receive Ports - RX PLL Ports ----------------------
        GTX1_GREFCLKRX_IN               =>      gtx1_grefclkrx_i,
        GTX1_GTXRXRESET_IN              =>      gtx1_gtxrxreset_i,
        GTX1_MGTREFCLKRX_IN             =>      q0_clk0_refclk_i_i,
        GTX1_NORTHREFCLKRX_IN           =>      gtx1_northrefclkrx_i,
        GTX1_PERFCLKRX_IN               =>      gtx1_perfclkrx_i,
        GTX1_PLLRXRESET_IN              =>      gtx1_pllrxreset_i,
        GTX1_RXPLLLKDET_OUT             =>      gtx1_rxplllkdet_i,
        GTX1_RXPLLREFSELDY_IN           =>      gtx1_rxpllrefseldy_i,
        GTX1_RXRESETDONE_OUT            =>      gtx1_rxresetdone_i,
        GTX1_SOUTHREFCLKRX_IN           =>      gtx1_southrefclkrx_i,
        ----------------- Receive Ports - RX Polarity Control Ports ----------------
        GTX1_RXPOLARITY_IN              =>      gtx1_rxpolarity_i,
        ---------------- Transmit Ports - 8b10b Encoder Control Ports --------------
        GTX1_TXCHARISK_IN               =>      gtx1_txcharisk_i,
        ------------------ Transmit Ports - TX Data Path interface -----------------
        GTX1_TXDATA_IN                  =>      gtx1_txdata_i,
        GTX1_TXOUTCLK_OUT               =>      gtx1_txoutclk_i,
        GTX1_TXRESET_IN                 =>      gtx1_txreset_i,
        GTX1_TXUSRCLK_IN                =>      gtx0_txusrclk_i,
        GTX1_TXUSRCLK2_IN               =>      gtx0_txusrclk2_i,
        ---------------- Transmit Ports - TX Driver and OOB signaling --------------
        GTX1_TXDIFFCTRL_IN              =>      gtx1_txdiffctrl_i,
        GTX1_TXN_OUT                    =>      TXN_OUT(1),
        GTX1_TXP_OUT                    =>      TXP_OUT(1),
        GTX1_TXPOSTEMPHASIS_IN          =>      gtx1_txpostemphasis_i,
        --------------- Transmit Ports - TX Driver and OOB signalling --------------
        GTX1_TXPREEMPHASIS_IN           =>      gtx1_txpreemphasis_i,
        ----------------------- Transmit Ports - TX PLL Ports ----------------------
        GTX1_GREFCLKTX_IN               =>      gtx1_grefclktx_i,
        GTX1_GTXTXRESET_IN              =>      gtx1_gtxtxreset_i,
        GTX1_NORTHREFCLKTX_IN           =>      gtx1_northrefclktx_i,
        GTX1_PERFCLKTX_IN               =>      gtx1_perfclktx_i,
        GTX1_SOUTHREFCLKTX_IN           =>      gtx1_southrefclktx_i,
        GTX1_TXPLLREFSELDY_IN           =>      gtx1_txpllrefseldy_i,
        GTX1_TXRESETDONE_OUT            =>      gtx1_txresetdone_i,
        -------------------- Transmit Ports - TX Polarity Control ------------------
        GTX1_TXPOLARITY_IN              =>      gtx1_txpolarity_i


    );

    -- Hold the TX in reset till the TX user clocks are stable
    gtx0_txreset_i <= not txoutclk_mmcm0_locked_i;
   
 
    gtx1_txreset_i <= not(gtx1_rxplllkdet_i and txoutclk_mmcm0_locked_i);
 
 

    -- Hold the RX in reset till the RX user clocks are stable
  
    gtx0_rxreset_i <= not txoutclk_mmcm0_locked_i;
  
 
    gtx1_rxreset_i <= not(gtx1_rxplllkdet_i and txoutclk_mmcm0_locked_i);
 





    -------------------------- User Module Resets -----------------------------
    -- All the User Modules i.e. FRAME_GEN, FRAME_CHECK and the sync modules
    -- are held in reset till the RESETDONE goes high. 
    -- The RESETDONE is registered a couple of times on USRCLK2 and connected 
    -- to the reset of the modules
    
    process( gtx0_txusrclk2_i)
    begin
         if(gtx0_txusrclk2_i'event and gtx0_txusrclk2_i = '1') then
            gtx0_rxresetdone_i_r  <= gtx0_rxresetdone_i   after DLY;
         end if; 
    end process; 

    process( gtx0_txusrclk2_i,gtx0_rxresetdone_i_r)
    begin
        if(gtx0_rxresetdone_i_r = '0') then
            gtx0_rxresetdone_r    <= '0'   after DLY;
            gtx0_rxresetdone_r2   <= '0'   after DLY;
        elsif(gtx0_txusrclk2_i'event and gtx0_txusrclk2_i = '1') then
            gtx0_rxresetdone_r    <= gtx0_rxresetdone_i_r after DLY;
            gtx0_rxresetdone_r2   <= gtx0_rxresetdone_r   after DLY;
        end if;
    end process;

    process( gtx0_txusrclk2_i)
    begin
         if(gtx0_txusrclk2_i'event and gtx0_txusrclk2_i = '1') then
            gtx0_rxresetdone_r3  <= gtx0_rxresetdone_r2   after DLY;
         end if; 
    end process; 

    process( gtx0_txusrclk2_i,gtx0_txresetdone_i)
    begin
        if(gtx0_txresetdone_i = '0') then
            gtx0_txresetdone_r  <= '0'   after DLY;
            gtx0_txresetdone_r2 <= '0'   after DLY;
        elsif(gtx0_txusrclk2_i'event and gtx0_txusrclk2_i = '1') then
            gtx0_txresetdone_r  <= gtx0_txresetdone_i   after DLY;
            gtx0_txresetdone_r2 <= gtx0_txresetdone_r   after DLY;
        end if;
    end process;
    process( gtx0_txusrclk2_i)
    begin
         if(gtx0_txusrclk2_i'event and gtx0_txusrclk2_i = '1') then
            gtx1_rxresetdone_i_r  <= gtx1_rxresetdone_i   after DLY;
         end if; 
    end process; 

    process( gtx0_txusrclk2_i,gtx1_rxresetdone_i_r)
    begin
        if(gtx1_rxresetdone_i_r = '0') then
            gtx1_rxresetdone_r    <= '0'   after DLY;
            gtx1_rxresetdone_r2   <= '0'   after DLY;
        elsif(gtx0_txusrclk2_i'event and gtx0_txusrclk2_i = '1') then
            gtx1_rxresetdone_r    <= gtx1_rxresetdone_i_r after DLY;
            gtx1_rxresetdone_r2   <= gtx1_rxresetdone_r   after DLY;
        end if;
    end process;

    process( gtx0_txusrclk2_i)
    begin
         if(gtx0_txusrclk2_i'event and gtx0_txusrclk2_i = '1') then
            gtx1_rxresetdone_r3  <= gtx1_rxresetdone_r2   after DLY;
         end if; 
    end process; 

    process( gtx0_txusrclk2_i,gtx1_txresetdone_i)
    begin
        if(gtx1_txresetdone_i = '0') then
            gtx1_txresetdone_r  <= '0'   after DLY;
            gtx1_txresetdone_r2 <= '0'   after DLY;
        elsif(gtx0_txusrclk2_i'event and gtx0_txusrclk2_i = '1') then
            gtx1_txresetdone_r  <= gtx1_txresetdone_i   after DLY;
            gtx1_txresetdone_r2 <= gtx1_txresetdone_r   after DLY;
        end if;
    end process;


    ------------------------------ Frame Generators ---------------------------
    -- The example design uses Block RAM based frame generators to provide test
    -- data to the GTXs for transmission. By default the frame generators are 
    -- loaded with an incrementing data sequence that includes commas/alignment
    -- characters for alignment. If your protocol uses channel bonding, the 
    -- frame generator will also be preloaded with a channel bonding sequence.
    
    -- You can modify the data transmitted by changing the INIT values of the frame
    -- generator in this file. Pay careful attention to bit order and the spacing
    -- of your control and alignment characters.

    gtx0_frame_gen : FRAME_GEN
    generic map
    (
        WORDS_IN_BRAM                   =>      EXAMPLE_WORDS_IN_BRAM,
        MEM_00                  =>  x"0000000600000005000000040000000300000002000000bc0000000100000000",
        MEM_01                  =>  x"0000000e0000000d0000000c0000000b0000000a000000090000000800000007",
        MEM_02                  =>  x"000000160000001500000014000000130000001200000011000000100000000f",
        MEM_03                  =>  x"0000001e0000001d0000001c0000001b0000001a000000190000001800000017",
        MEM_04                  =>  x"000000260000002500000024000000230000002200000021000000200000001f",
        MEM_05                  =>  x"0000002e0000002d0000002c0000002b0000002a000000290000002800000027",
        MEM_06                  =>  x"000000360000003500000034000000330000003200000031000000300000002f",
        MEM_07                  =>  x"0000003e0000003d0000003c0000003b0000003a000000390000003800000037",
        MEM_08                  =>  x"000000460000004500000044000000430000004200000041000000400000003f",
        MEM_09                  =>  x"0000004e0000004d0000004c0000004b0000004a000000490000004800000047",
        MEM_0A                  =>  x"000000560000005500000054000000530000005200000051000000500000004f",
        MEM_0B                  =>  x"0000005e0000005d0000005c0000005b0000005a000000590000005800000057",
        MEM_0C                  =>  x"000000660000006500000064000000630000006200000061000000600000005f",
        MEM_0D                  =>  x"0000006e0000006d0000006c0000006b0000006a000000690000006800000067",
        MEM_0E                  =>  x"000000760000007500000074000000730000007200000071000000700000006f",
        MEM_0F                  =>  x"0000007e0000007d0000007c0000007b0000007a000000790000007800000077",
        MEM_10                  =>  x"0000000600000005000000040000000300000002000000bc0000000100000000",
        MEM_11                  =>  x"0000000e0000000d0000000c0000000b0000000a000000090000000800000007",
        MEM_12                  =>  x"000000160000001500000014000000130000001200000011000000100000000f",
        MEM_13                  =>  x"0000001e0000001d0000001c0000001b0000001a000000190000001800000017",
        MEM_14                  =>  x"000000260000002500000024000000230000002200000021000000200000001f",
        MEM_15                  =>  x"0000002e0000002d0000002c0000002b0000002a000000290000002800000027",
        MEM_16                  =>  x"000000360000003500000034000000330000003200000031000000300000002f",
        MEM_17                  =>  x"0000003e0000003d0000003c0000003b0000003a000000390000003800000037",
        MEM_18                  =>  x"000000460000004500000044000000430000004200000041000000400000003f",
        MEM_19                  =>  x"0000004e0000004d0000004c0000004b0000004a000000490000004800000047",
        MEM_1A                  =>  x"000000560000005500000054000000530000005200000051000000500000004f",
        MEM_1B                  =>  x"0000005e0000005d0000005c0000005b0000005a000000590000005800000057",
        MEM_1C                  =>  x"000000660000006500000064000000630000006200000061000000600000005f",
        MEM_1D                  =>  x"0000006e0000006d0000006c0000006b0000006a000000690000006800000067",
        MEM_1E                  =>  x"000000760000007500000074000000730000007200000071000000700000006f",
        MEM_1F                  =>  x"0000007e0000007d0000007c0000007b0000007a000000790000007800000077",
        MEM_20                  =>  x"0000000600000005000000040000000300000002000000bc0000000100000000",
        MEM_21                  =>  x"0000000e0000000d0000000c0000000b0000000a000000090000000800000007",
        MEM_22                  =>  x"000000160000001500000014000000130000001200000011000000100000000f",
        MEM_23                  =>  x"0000001e0000001d0000001c0000001b0000001a000000190000001800000017",
        MEM_24                  =>  x"000000260000002500000024000000230000002200000021000000200000001f",
        MEM_25                  =>  x"0000002e0000002d0000002c0000002b0000002a000000290000002800000027",
        MEM_26                  =>  x"000000360000003500000034000000330000003200000031000000300000002f",
        MEM_27                  =>  x"0000003e0000003d0000003c0000003b0000003a000000390000003800000037",
        MEM_28                  =>  x"000000460000004500000044000000430000004200000041000000400000003f",
        MEM_29                  =>  x"0000004e0000004d0000004c0000004b0000004a000000490000004800000047",
        MEM_2A                  =>  x"000000560000005500000054000000530000005200000051000000500000004f",
        MEM_2B                  =>  x"0000005e0000005d0000005c0000005b0000005a000000590000005800000057",
        MEM_2C                  =>  x"000000660000006500000064000000630000006200000061000000600000005f",
        MEM_2D                  =>  x"0000006e0000006d0000006c0000006b0000006a000000690000006800000067",
        MEM_2E                  =>  x"000000760000007500000074000000730000007200000071000000700000006f",
        MEM_2F                  =>  x"0000007e0000007d0000007c0000007b0000007a000000790000007800000077",
        MEM_30                  =>  x"0000000600000005000000040000000300000002000000bc0000000100000000",
        MEM_31                  =>  x"0000000e0000000d0000000c0000000b0000000a000000090000000800000007",
        MEM_32                  =>  x"000000160000001500000014000000130000001200000011000000100000000f",
        MEM_33                  =>  x"0000001e0000001d0000001c0000001b0000001a000000190000001800000017",
        MEM_34                  =>  x"000000260000002500000024000000230000002200000021000000200000001f",
        MEM_35                  =>  x"0000002e0000002d0000002c0000002b0000002a000000290000002800000027",
        MEM_36                  =>  x"000000360000003500000034000000330000003200000031000000300000002f",
        MEM_37                  =>  x"0000003e0000003d0000003c0000003b0000003a000000390000003800000037",
        MEM_38                  =>  x"000000460000004500000044000000430000004200000041000000400000003f",
        MEM_39                  =>  x"0000004e0000004d0000004c0000004b0000004a000000490000004800000047",
        MEM_3A                  =>  x"000000560000005500000054000000530000005200000051000000500000004f",
        MEM_3B                  =>  x"0000005e0000005d0000005c0000005b0000005a000000590000005800000057",
        MEM_3C                  =>  x"000000660000006500000064000000630000006200000061000000600000005f",
        MEM_3D                  =>  x"0000006e0000006d0000006c0000006b0000006a000000690000006800000067",
        MEM_3E                  =>  x"000000760000007500000074000000730000007200000071000000700000006f",
        MEM_3F                  =>  x"0000007e0000007d0000007c0000007b0000007a000000790000007800000077",
        MEMP_00                  =>  x"0000000000000000000000000000000000000000000000000000000000000100",
        MEMP_01                  =>  x"0000000000000000000000000000000000000000000000000000000000000000",
        MEMP_02                  =>  x"0000000000000000000000000000000000000000000000000000000000000100",
        MEMP_03                  =>  x"0000000000000000000000000000000000000000000000000000000000000000",
        MEMP_04                  =>  x"0000000000000000000000000000000000000000000000000000000000000100",
        MEMP_05                  =>  x"0000000000000000000000000000000000000000000000000000000000000000",
        MEMP_06                  =>  x"0000000000000000000000000000000000000000000000000000000000000100",
        MEMP_07                  =>  x"0000000000000000000000000000000000000000000000000000000000000000"
    )
    port map
    (
        -- User Interface
        TX_DATA(39 downto 8)            =>      gtx0_txdata_float_i,
        TX_DATA(7 downto 0)             =>      gtx0_txdata_i,
 
        TX_CHARISK(3 downto 1)          =>      gtx0_txcharisk_float_i,
        TX_CHARISK(0)                   =>      gtx0_txcharisk_i,
        -- System Interface
        USER_CLK                        =>      gtx0_txusrclk2_i,
        SYSTEM_RESET                    =>      gtx0_tx_system_reset_c
    );
    
    gtx1_frame_gen : FRAME_GEN
    generic map
    (
        WORDS_IN_BRAM                   =>      EXAMPLE_WORDS_IN_BRAM,
        MEM_00                  =>  x"0000000600000005000000040000000300000002000000bc0000000100000000",
        MEM_01                  =>  x"0000000e0000000d0000000c0000000b0000000a000000090000000800000007",
        MEM_02                  =>  x"000000160000001500000014000000130000001200000011000000100000000f",
        MEM_03                  =>  x"0000001e0000001d0000001c0000001b0000001a000000190000001800000017",
        MEM_04                  =>  x"000000260000002500000024000000230000002200000021000000200000001f",
        MEM_05                  =>  x"0000002e0000002d0000002c0000002b0000002a000000290000002800000027",
        MEM_06                  =>  x"000000360000003500000034000000330000003200000031000000300000002f",
        MEM_07                  =>  x"0000003e0000003d0000003c0000003b0000003a000000390000003800000037",
        MEM_08                  =>  x"000000460000004500000044000000430000004200000041000000400000003f",
        MEM_09                  =>  x"0000004e0000004d0000004c0000004b0000004a000000490000004800000047",
        MEM_0A                  =>  x"000000560000005500000054000000530000005200000051000000500000004f",
        MEM_0B                  =>  x"0000005e0000005d0000005c0000005b0000005a000000590000005800000057",
        MEM_0C                  =>  x"000000660000006500000064000000630000006200000061000000600000005f",
        MEM_0D                  =>  x"0000006e0000006d0000006c0000006b0000006a000000690000006800000067",
        MEM_0E                  =>  x"000000760000007500000074000000730000007200000071000000700000006f",
        MEM_0F                  =>  x"0000007e0000007d0000007c0000007b0000007a000000790000007800000077",
        MEM_10                  =>  x"0000000600000005000000040000000300000002000000bc0000000100000000",
        MEM_11                  =>  x"0000000e0000000d0000000c0000000b0000000a000000090000000800000007",
        MEM_12                  =>  x"000000160000001500000014000000130000001200000011000000100000000f",
        MEM_13                  =>  x"0000001e0000001d0000001c0000001b0000001a000000190000001800000017",
        MEM_14                  =>  x"000000260000002500000024000000230000002200000021000000200000001f",
        MEM_15                  =>  x"0000002e0000002d0000002c0000002b0000002a000000290000002800000027",
        MEM_16                  =>  x"000000360000003500000034000000330000003200000031000000300000002f",
        MEM_17                  =>  x"0000003e0000003d0000003c0000003b0000003a000000390000003800000037",
        MEM_18                  =>  x"000000460000004500000044000000430000004200000041000000400000003f",
        MEM_19                  =>  x"0000004e0000004d0000004c0000004b0000004a000000490000004800000047",
        MEM_1A                  =>  x"000000560000005500000054000000530000005200000051000000500000004f",
        MEM_1B                  =>  x"0000005e0000005d0000005c0000005b0000005a000000590000005800000057",
        MEM_1C                  =>  x"000000660000006500000064000000630000006200000061000000600000005f",
        MEM_1D                  =>  x"0000006e0000006d0000006c0000006b0000006a000000690000006800000067",
        MEM_1E                  =>  x"000000760000007500000074000000730000007200000071000000700000006f",
        MEM_1F                  =>  x"0000007e0000007d0000007c0000007b0000007a000000790000007800000077",
        MEM_20                  =>  x"0000000600000005000000040000000300000002000000bc0000000100000000",
        MEM_21                  =>  x"0000000e0000000d0000000c0000000b0000000a000000090000000800000007",
        MEM_22                  =>  x"000000160000001500000014000000130000001200000011000000100000000f",
        MEM_23                  =>  x"0000001e0000001d0000001c0000001b0000001a000000190000001800000017",
        MEM_24                  =>  x"000000260000002500000024000000230000002200000021000000200000001f",
        MEM_25                  =>  x"0000002e0000002d0000002c0000002b0000002a000000290000002800000027",
        MEM_26                  =>  x"000000360000003500000034000000330000003200000031000000300000002f",
        MEM_27                  =>  x"0000003e0000003d0000003c0000003b0000003a000000390000003800000037",
        MEM_28                  =>  x"000000460000004500000044000000430000004200000041000000400000003f",
        MEM_29                  =>  x"0000004e0000004d0000004c0000004b0000004a000000490000004800000047",
        MEM_2A                  =>  x"000000560000005500000054000000530000005200000051000000500000004f",
        MEM_2B                  =>  x"0000005e0000005d0000005c0000005b0000005a000000590000005800000057",
        MEM_2C                  =>  x"000000660000006500000064000000630000006200000061000000600000005f",
        MEM_2D                  =>  x"0000006e0000006d0000006c0000006b0000006a000000690000006800000067",
        MEM_2E                  =>  x"000000760000007500000074000000730000007200000071000000700000006f",
        MEM_2F                  =>  x"0000007e0000007d0000007c0000007b0000007a000000790000007800000077",
        MEM_30                  =>  x"0000000600000005000000040000000300000002000000bc0000000100000000",
        MEM_31                  =>  x"0000000e0000000d0000000c0000000b0000000a000000090000000800000007",
        MEM_32                  =>  x"000000160000001500000014000000130000001200000011000000100000000f",
        MEM_33                  =>  x"0000001e0000001d0000001c0000001b0000001a000000190000001800000017",
        MEM_34                  =>  x"000000260000002500000024000000230000002200000021000000200000001f",
        MEM_35                  =>  x"0000002e0000002d0000002c0000002b0000002a000000290000002800000027",
        MEM_36                  =>  x"000000360000003500000034000000330000003200000031000000300000002f",
        MEM_37                  =>  x"0000003e0000003d0000003c0000003b0000003a000000390000003800000037",
        MEM_38                  =>  x"000000460000004500000044000000430000004200000041000000400000003f",
        MEM_39                  =>  x"0000004e0000004d0000004c0000004b0000004a000000490000004800000047",
        MEM_3A                  =>  x"000000560000005500000054000000530000005200000051000000500000004f",
        MEM_3B                  =>  x"0000005e0000005d0000005c0000005b0000005a000000590000005800000057",
        MEM_3C                  =>  x"000000660000006500000064000000630000006200000061000000600000005f",
        MEM_3D                  =>  x"0000006e0000006d0000006c0000006b0000006a000000690000006800000067",
        MEM_3E                  =>  x"000000760000007500000074000000730000007200000071000000700000006f",
        MEM_3F                  =>  x"0000007e0000007d0000007c0000007b0000007a000000790000007800000077",
        MEMP_00                  =>  x"0000000000000000000000000000000000000000000000000000000000000100",
        MEMP_01                  =>  x"0000000000000000000000000000000000000000000000000000000000000000",
        MEMP_02                  =>  x"0000000000000000000000000000000000000000000000000000000000000100",
        MEMP_03                  =>  x"0000000000000000000000000000000000000000000000000000000000000000",
        MEMP_04                  =>  x"0000000000000000000000000000000000000000000000000000000000000100",
        MEMP_05                  =>  x"0000000000000000000000000000000000000000000000000000000000000000",
        MEMP_06                  =>  x"0000000000000000000000000000000000000000000000000000000000000100",
        MEMP_07                  =>  x"0000000000000000000000000000000000000000000000000000000000000000"
    )
    port map
    (
        -- User Interface
        TX_DATA(39 downto 8)            =>      gtx1_txdata_float_i,
        TX_DATA(7 downto 0)             =>      gtx1_txdata_i,
 
        TX_CHARISK(3 downto 1)          =>      gtx1_txcharisk_float_i,
        TX_CHARISK(0)                   =>      gtx1_txcharisk_i,
        -- System Interface
        USER_CLK                        =>      gtx0_txusrclk2_i,
        SYSTEM_RESET                    =>      gtx1_tx_system_reset_c
    );
    


    ---------------------------------- Frame Checkers -------------------------
    -- The example design uses Block RAM based frame checkers to verify incoming  
    -- data. By default the frame generators are loaded with a data sequence that 
    -- matches the outgoing sequence of the frame generators for the TX ports.
    
    -- You can modify the expected data sequence by changing the INIT values of the frame
    -- checkers in this file. Pay careful attention to bit order and the spacing
    -- of your control and alignment characters.
    
    -- When the frame checker receives data, it attempts to synchronise to the 
    -- incoming pattern by looking for the first sequence in the pattern. Once it 
    -- finds the first sequence, it increments through the sequence, and indicates an 
    -- error whenever the next value received does not match the expected value.

    gtx0_frame_check_reset_i                     <= reset_on_data_error_i when (EXAMPLE_CONFIG_INDEPENDENT_LANES=0) else gtx0_matchn_i;

    -- gtx0_frame_check0 is always connected to the lane with the start of char
    -- and this lane starts off the data checking on all the other lanes. The INC_IN port is tied off
    gtx0_inc_in_i                                <= '0';

    process(gtx0_txusrclk2_i)
    begin 
       if(gtx0_txusrclk2_i'event and gtx0_txusrclk2_i='1') then
         gtx0_rxdata_r <= gtx0_rxdata_i   after DLY;
       end if;
    end process;

    process(gtx0_txusrclk2_i)
    begin 
       if(gtx0_txusrclk2_i'event and gtx0_txusrclk2_i='1') then
         gtx0_rxcharisk_r(0) <= gtx0_rxcharisk_i   after DLY;
       end if;
    end process;
 

 
 
    gtx0_frame_check : FRAME_CHECK
    generic map
    (
        RX_DATA_WIDTH                   =>      8,
        RXCTRL_WIDTH                    =>      1,
        USE_COMMA                       =>      1,
        WORDS_IN_BRAM                   =>      EXAMPLE_WORDS_IN_BRAM,
        CONFIG_INDEPENDENT_LANES        =>      1,
        START_OF_PACKET_CHAR            =>      x"02bc",
        MEM_00                  =>  x"0000000600000005000000040000000300000002000000bc0000000100000000",
        MEM_01                  =>  x"0000000e0000000d0000000c0000000b0000000a000000090000000800000007",
        MEM_02                  =>  x"000000160000001500000014000000130000001200000011000000100000000f",
        MEM_03                  =>  x"0000001e0000001d0000001c0000001b0000001a000000190000001800000017",
        MEM_04                  =>  x"000000260000002500000024000000230000002200000021000000200000001f",
        MEM_05                  =>  x"0000002e0000002d0000002c0000002b0000002a000000290000002800000027",
        MEM_06                  =>  x"000000360000003500000034000000330000003200000031000000300000002f",
        MEM_07                  =>  x"0000003e0000003d0000003c0000003b0000003a000000390000003800000037",
        MEM_08                  =>  x"000000460000004500000044000000430000004200000041000000400000003f",
        MEM_09                  =>  x"0000004e0000004d0000004c0000004b0000004a000000490000004800000047",
        MEM_0A                  =>  x"000000560000005500000054000000530000005200000051000000500000004f",
        MEM_0B                  =>  x"0000005e0000005d0000005c0000005b0000005a000000590000005800000057",
        MEM_0C                  =>  x"000000660000006500000064000000630000006200000061000000600000005f",
        MEM_0D                  =>  x"0000006e0000006d0000006c0000006b0000006a000000690000006800000067",
        MEM_0E                  =>  x"000000760000007500000074000000730000007200000071000000700000006f",
        MEM_0F                  =>  x"0000007e0000007d0000007c0000007b0000007a000000790000007800000077",
        MEM_10                  =>  x"0000000600000005000000040000000300000002000000bc0000000100000000",
        MEM_11                  =>  x"0000000e0000000d0000000c0000000b0000000a000000090000000800000007",
        MEM_12                  =>  x"000000160000001500000014000000130000001200000011000000100000000f",
        MEM_13                  =>  x"0000001e0000001d0000001c0000001b0000001a000000190000001800000017",
        MEM_14                  =>  x"000000260000002500000024000000230000002200000021000000200000001f",
        MEM_15                  =>  x"0000002e0000002d0000002c0000002b0000002a000000290000002800000027",
        MEM_16                  =>  x"000000360000003500000034000000330000003200000031000000300000002f",
        MEM_17                  =>  x"0000003e0000003d0000003c0000003b0000003a000000390000003800000037",
        MEM_18                  =>  x"000000460000004500000044000000430000004200000041000000400000003f",
        MEM_19                  =>  x"0000004e0000004d0000004c0000004b0000004a000000490000004800000047",
        MEM_1A                  =>  x"000000560000005500000054000000530000005200000051000000500000004f",
        MEM_1B                  =>  x"0000005e0000005d0000005c0000005b0000005a000000590000005800000057",
        MEM_1C                  =>  x"000000660000006500000064000000630000006200000061000000600000005f",
        MEM_1D                  =>  x"0000006e0000006d0000006c0000006b0000006a000000690000006800000067",
        MEM_1E                  =>  x"000000760000007500000074000000730000007200000071000000700000006f",
        MEM_1F                  =>  x"0000007e0000007d0000007c0000007b0000007a000000790000007800000077",
        MEM_20                  =>  x"0000000600000005000000040000000300000002000000bc0000000100000000",
        MEM_21                  =>  x"0000000e0000000d0000000c0000000b0000000a000000090000000800000007",
        MEM_22                  =>  x"000000160000001500000014000000130000001200000011000000100000000f",
        MEM_23                  =>  x"0000001e0000001d0000001c0000001b0000001a000000190000001800000017",
        MEM_24                  =>  x"000000260000002500000024000000230000002200000021000000200000001f",
        MEM_25                  =>  x"0000002e0000002d0000002c0000002b0000002a000000290000002800000027",
        MEM_26                  =>  x"000000360000003500000034000000330000003200000031000000300000002f",
        MEM_27                  =>  x"0000003e0000003d0000003c0000003b0000003a000000390000003800000037",
        MEM_28                  =>  x"000000460000004500000044000000430000004200000041000000400000003f",
        MEM_29                  =>  x"0000004e0000004d0000004c0000004b0000004a000000490000004800000047",
        MEM_2A                  =>  x"000000560000005500000054000000530000005200000051000000500000004f",
        MEM_2B                  =>  x"0000005e0000005d0000005c0000005b0000005a000000590000005800000057",
        MEM_2C                  =>  x"000000660000006500000064000000630000006200000061000000600000005f",
        MEM_2D                  =>  x"0000006e0000006d0000006c0000006b0000006a000000690000006800000067",
        MEM_2E                  =>  x"000000760000007500000074000000730000007200000071000000700000006f",
        MEM_2F                  =>  x"0000007e0000007d0000007c0000007b0000007a000000790000007800000077",
        MEM_30                  =>  x"0000000600000005000000040000000300000002000000bc0000000100000000",
        MEM_31                  =>  x"0000000e0000000d0000000c0000000b0000000a000000090000000800000007",
        MEM_32                  =>  x"000000160000001500000014000000130000001200000011000000100000000f",
        MEM_33                  =>  x"0000001e0000001d0000001c0000001b0000001a000000190000001800000017",
        MEM_34                  =>  x"000000260000002500000024000000230000002200000021000000200000001f",
        MEM_35                  =>  x"0000002e0000002d0000002c0000002b0000002a000000290000002800000027",
        MEM_36                  =>  x"000000360000003500000034000000330000003200000031000000300000002f",
        MEM_37                  =>  x"0000003e0000003d0000003c0000003b0000003a000000390000003800000037",
        MEM_38                  =>  x"000000460000004500000044000000430000004200000041000000400000003f",
        MEM_39                  =>  x"0000004e0000004d0000004c0000004b0000004a000000490000004800000047",
        MEM_3A                  =>  x"000000560000005500000054000000530000005200000051000000500000004f",
        MEM_3B                  =>  x"0000005e0000005d0000005c0000005b0000005a000000590000005800000057",
        MEM_3C                  =>  x"000000660000006500000064000000630000006200000061000000600000005f",
        MEM_3D                  =>  x"0000006e0000006d0000006c0000006b0000006a000000690000006800000067",
        MEM_3E                  =>  x"000000760000007500000074000000730000007200000071000000700000006f",
        MEM_3F                  =>  x"0000007e0000007d0000007c0000007b0000007a000000790000007800000077",
        MEMP_00                  =>  x"0000000000000000000000000000000000000000000000000000000000000100",
        MEMP_01                  =>  x"0000000000000000000000000000000000000000000000000000000000000000",
        MEMP_02                  =>  x"0000000000000000000000000000000000000000000000000000000000000100",
        MEMP_03                  =>  x"0000000000000000000000000000000000000000000000000000000000000000",
        MEMP_04                  =>  x"0000000000000000000000000000000000000000000000000000000000000100",
        MEMP_05                  =>  x"0000000000000000000000000000000000000000000000000000000000000000",
        MEMP_06                  =>  x"0000000000000000000000000000000000000000000000000000000000000100",
        MEMP_07                  =>  x"0000000000000000000000000000000000000000000000000000000000000000"
    )
    port map
    (
        -- MGT Interface
        RX_DATA                         =>      gtx0_rxdata_r,
        RXCTRL_IN                       =>      gtx0_rxcharisk_r,
        RX_ENMCOMMA_ALIGN               =>      gtx0_rxenmcommaalign_i,
        RX_ENPCOMMA_ALIGN               =>      gtx0_rxenpcommaalign_i,
        RX_ENCHAN_SYNC                  =>      open,
        RX_CHANBOND_SEQ                 =>      tied_to_ground_i,
        -- Control Interface
        INC_IN                          =>      gtx0_inc_in_i,
        INC_OUT                         =>      gtx0_inc_out_i,
        PATTERN_MATCH_N                 =>      gtx0_matchn_i,
        RESET_ON_ERROR                  =>      gtx0_frame_check_reset_i,
        -- System Interface
        USER_CLK                        =>      gtx0_txusrclk2_i,
        SYSTEM_RESET                    =>      gtx0_rx_system_reset_c,
        ERROR_COUNT                     =>      gtx0_error_count_i,
        TRACK_DATA                      =>      gtx0_track_data_i
    );
        
    gtx1_frame_check_reset_i                     <= reset_on_data_error_i when (EXAMPLE_CONFIG_INDEPENDENT_LANES=0) else gtx1_matchn_i;

    -- in the "independent lanes" configuration, each of the lanes looks for the unique start char and
    -- in this case, the INC_IN port is tied off.
    -- Else, the data checking is triggered by the "master" lane
    gtx1_inc_in_i                                <= gtx0_inc_out_i when (EXAMPLE_CONFIG_INDEPENDENT_LANES=0) else '0';

    process(gtx0_txusrclk2_i)
    begin 
       if(gtx0_txusrclk2_i'event and gtx0_txusrclk2_i='1') then
         gtx1_rxdata_r <= gtx1_rxdata_i   after DLY;
       end if;
    end process;

    process(gtx0_txusrclk2_i)
    begin 
       if(gtx0_txusrclk2_i'event and gtx0_txusrclk2_i='1') then
         gtx1_rxcharisk_r(0) <= gtx1_rxcharisk_i   after DLY;
       end if;
    end process;
 

 
 
    gtx1_frame_check : FRAME_CHECK
    generic map
    (
        RX_DATA_WIDTH                   =>      8,
        RXCTRL_WIDTH                    =>      1,
        USE_COMMA                       =>      1,
        WORDS_IN_BRAM                   =>      EXAMPLE_WORDS_IN_BRAM,
        CONFIG_INDEPENDENT_LANES        =>      EXAMPLE_CONFIG_INDEPENDENT_LANES,
        START_OF_PACKET_CHAR            =>      x"02bc",
        MEM_00                  =>  x"0000000600000005000000040000000300000002000000bc0000000100000000",
        MEM_01                  =>  x"0000000e0000000d0000000c0000000b0000000a000000090000000800000007",
        MEM_02                  =>  x"000000160000001500000014000000130000001200000011000000100000000f",
        MEM_03                  =>  x"0000001e0000001d0000001c0000001b0000001a000000190000001800000017",
        MEM_04                  =>  x"000000260000002500000024000000230000002200000021000000200000001f",
        MEM_05                  =>  x"0000002e0000002d0000002c0000002b0000002a000000290000002800000027",
        MEM_06                  =>  x"000000360000003500000034000000330000003200000031000000300000002f",
        MEM_07                  =>  x"0000003e0000003d0000003c0000003b0000003a000000390000003800000037",
        MEM_08                  =>  x"000000460000004500000044000000430000004200000041000000400000003f",
        MEM_09                  =>  x"0000004e0000004d0000004c0000004b0000004a000000490000004800000047",
        MEM_0A                  =>  x"000000560000005500000054000000530000005200000051000000500000004f",
        MEM_0B                  =>  x"0000005e0000005d0000005c0000005b0000005a000000590000005800000057",
        MEM_0C                  =>  x"000000660000006500000064000000630000006200000061000000600000005f",
        MEM_0D                  =>  x"0000006e0000006d0000006c0000006b0000006a000000690000006800000067",
        MEM_0E                  =>  x"000000760000007500000074000000730000007200000071000000700000006f",
        MEM_0F                  =>  x"0000007e0000007d0000007c0000007b0000007a000000790000007800000077",
        MEM_10                  =>  x"0000000600000005000000040000000300000002000000bc0000000100000000",
        MEM_11                  =>  x"0000000e0000000d0000000c0000000b0000000a000000090000000800000007",
        MEM_12                  =>  x"000000160000001500000014000000130000001200000011000000100000000f",
        MEM_13                  =>  x"0000001e0000001d0000001c0000001b0000001a000000190000001800000017",
        MEM_14                  =>  x"000000260000002500000024000000230000002200000021000000200000001f",
        MEM_15                  =>  x"0000002e0000002d0000002c0000002b0000002a000000290000002800000027",
        MEM_16                  =>  x"000000360000003500000034000000330000003200000031000000300000002f",
        MEM_17                  =>  x"0000003e0000003d0000003c0000003b0000003a000000390000003800000037",
        MEM_18                  =>  x"000000460000004500000044000000430000004200000041000000400000003f",
        MEM_19                  =>  x"0000004e0000004d0000004c0000004b0000004a000000490000004800000047",
        MEM_1A                  =>  x"000000560000005500000054000000530000005200000051000000500000004f",
        MEM_1B                  =>  x"0000005e0000005d0000005c0000005b0000005a000000590000005800000057",
        MEM_1C                  =>  x"000000660000006500000064000000630000006200000061000000600000005f",
        MEM_1D                  =>  x"0000006e0000006d0000006c0000006b0000006a000000690000006800000067",
        MEM_1E                  =>  x"000000760000007500000074000000730000007200000071000000700000006f",
        MEM_1F                  =>  x"0000007e0000007d0000007c0000007b0000007a000000790000007800000077",
        MEM_20                  =>  x"0000000600000005000000040000000300000002000000bc0000000100000000",
        MEM_21                  =>  x"0000000e0000000d0000000c0000000b0000000a000000090000000800000007",
        MEM_22                  =>  x"000000160000001500000014000000130000001200000011000000100000000f",
        MEM_23                  =>  x"0000001e0000001d0000001c0000001b0000001a000000190000001800000017",
        MEM_24                  =>  x"000000260000002500000024000000230000002200000021000000200000001f",
        MEM_25                  =>  x"0000002e0000002d0000002c0000002b0000002a000000290000002800000027",
        MEM_26                  =>  x"000000360000003500000034000000330000003200000031000000300000002f",
        MEM_27                  =>  x"0000003e0000003d0000003c0000003b0000003a000000390000003800000037",
        MEM_28                  =>  x"000000460000004500000044000000430000004200000041000000400000003f",
        MEM_29                  =>  x"0000004e0000004d0000004c0000004b0000004a000000490000004800000047",
        MEM_2A                  =>  x"000000560000005500000054000000530000005200000051000000500000004f",
        MEM_2B                  =>  x"0000005e0000005d0000005c0000005b0000005a000000590000005800000057",
        MEM_2C                  =>  x"000000660000006500000064000000630000006200000061000000600000005f",
        MEM_2D                  =>  x"0000006e0000006d0000006c0000006b0000006a000000690000006800000067",
        MEM_2E                  =>  x"000000760000007500000074000000730000007200000071000000700000006f",
        MEM_2F                  =>  x"0000007e0000007d0000007c0000007b0000007a000000790000007800000077",
        MEM_30                  =>  x"0000000600000005000000040000000300000002000000bc0000000100000000",
        MEM_31                  =>  x"0000000e0000000d0000000c0000000b0000000a000000090000000800000007",
        MEM_32                  =>  x"000000160000001500000014000000130000001200000011000000100000000f",
        MEM_33                  =>  x"0000001e0000001d0000001c0000001b0000001a000000190000001800000017",
        MEM_34                  =>  x"000000260000002500000024000000230000002200000021000000200000001f",
        MEM_35                  =>  x"0000002e0000002d0000002c0000002b0000002a000000290000002800000027",
        MEM_36                  =>  x"000000360000003500000034000000330000003200000031000000300000002f",
        MEM_37                  =>  x"0000003e0000003d0000003c0000003b0000003a000000390000003800000037",
        MEM_38                  =>  x"000000460000004500000044000000430000004200000041000000400000003f",
        MEM_39                  =>  x"0000004e0000004d0000004c0000004b0000004a000000490000004800000047",
        MEM_3A                  =>  x"000000560000005500000054000000530000005200000051000000500000004f",
        MEM_3B                  =>  x"0000005e0000005d0000005c0000005b0000005a000000590000005800000057",
        MEM_3C                  =>  x"000000660000006500000064000000630000006200000061000000600000005f",
        MEM_3D                  =>  x"0000006e0000006d0000006c0000006b0000006a000000690000006800000067",
        MEM_3E                  =>  x"000000760000007500000074000000730000007200000071000000700000006f",
        MEM_3F                  =>  x"0000007e0000007d0000007c0000007b0000007a000000790000007800000077",
        MEMP_00                  =>  x"0000000000000000000000000000000000000000000000000000000000000100",
        MEMP_01                  =>  x"0000000000000000000000000000000000000000000000000000000000000000",
        MEMP_02                  =>  x"0000000000000000000000000000000000000000000000000000000000000100",
        MEMP_03                  =>  x"0000000000000000000000000000000000000000000000000000000000000000",
        MEMP_04                  =>  x"0000000000000000000000000000000000000000000000000000000000000100",
        MEMP_05                  =>  x"0000000000000000000000000000000000000000000000000000000000000000",
        MEMP_06                  =>  x"0000000000000000000000000000000000000000000000000000000000000100",
        MEMP_07                  =>  x"0000000000000000000000000000000000000000000000000000000000000000"
    )
    port map
    (
        -- MGT Interface
        RX_DATA                         =>      gtx1_rxdata_r,
        RXCTRL_IN                       =>      gtx1_rxcharisk_r,
        RX_ENMCOMMA_ALIGN               =>      gtx1_rxenmcommaalign_i,
        RX_ENPCOMMA_ALIGN               =>      gtx1_rxenpcommaalign_i,
        RX_ENCHAN_SYNC                  =>      open,
        RX_CHANBOND_SEQ                 =>      tied_to_ground_i,
        -- Control Interface
        INC_IN                          =>      gtx1_inc_in_i,
        INC_OUT                         =>      gtx1_inc_out_i,
        PATTERN_MATCH_N                 =>      gtx1_matchn_i,
        RESET_ON_ERROR                  =>      gtx1_frame_check_reset_i,
        -- System Interface
        USER_CLK                        =>      gtx0_txusrclk2_i,
        SYSTEM_RESET                    =>      gtx1_rx_system_reset_c,
        ERROR_COUNT                     =>      gtx1_error_count_i,
        TRACK_DATA                      =>      gtx1_track_data_i
    );
        


    TRACK_DATA_OUT                               <= track_data_out_i;

    track_data_out_i                             <= 
                                gtx0_track_data_i  and
                                gtx1_track_data_i ;



    ----------------------------- Chipscope Connections -----------------------
    -- When the example design is run in hardware, it uses chipscope to allow the
    -- example design and GTX wrapper to be controlled and monitored. The 
    -- EXAMPLE_USE_CHIPSCOPE parameter allows chipscope to be removed for simulation.
    
chipscope : if EXAMPLE_USE_CHIPSCOPE = 1 generate
    
    
    -- Shared VIO for all transievers 
    shared_vio_i : data_vio
    port map
    (
        control                         =>      shared_vio_control_i,
        clk                             =>      tied_to_ground_i,
        async_in                        =>      shared_vio_in_i,
        async_out                       =>      shared_vio_out_i,
        sync_in                         =>      tied_to_ground_vec_i(31 downto 0),
        sync_out                        =>      open
    );
    
    -- ICON for all VIOs 
    i_icon : icon
    port map
    (
        control0                        =>      shared_vio_control_i,
        control1                        =>      tx_data_vio_control_i,
        control2                        =>      rx_data_vio_control_i,
        control3                        =>      ila_control_i
    );

    
    -- TX VIO 
    tx_data_vio_i : data_vio
    port map
    (
        control                         =>      tx_data_vio_control_i,
        clk                             =>      gtx0_txusrclk2_i,
        async_in                        =>      tx_data_vio_async_in_i,
        async_out                       =>      tx_data_vio_async_out_i,
        sync_in                         =>      tx_data_vio_sync_in_i,
        sync_out                        =>      tx_data_vio_sync_out_i
    );
    
    -- RX VIO 
    rx_data_vio_i : data_vio
    port map
    (
        control                         =>      rx_data_vio_control_i,
        clk                             =>      gtx0_txusrclk2_i,
        async_in                        =>      rx_data_vio_async_in_i,
        async_out                       =>      rx_data_vio_async_out_i,
        sync_in                         =>      rx_data_vio_sync_in_i,
        sync_out                        =>      rx_data_vio_sync_out_i
    );
    
    -- RX ILA
    ila_i : ila
    port map
    (
        control                         =>      ila_control_i,
        clk                             =>      gtx0_txusrclk2_i,
        trig0                           =>      ila_in_i
    );



    -- assign resets for frame_gen modules
    gtx0_tx_system_reset_c                       <= not gtx0_txresetdone_r2 or user_tx_reset_i;
    gtx1_tx_system_reset_c                       <= not gtx1_txresetdone_r2 or user_tx_reset_i;
    -- assign resets for frame_check modules
    gtx0_rx_system_reset_c                       <= not gtx0_rxresetdone_r3 or user_rx_reset_i;
    gtx1_rx_system_reset_c                       <= not gtx1_rxresetdone_r3 or user_rx_reset_i;

    gtx0_gtxtxreset_i                            <= gtxtxreset_i or gtxrxreset_i;
    gtx0_gtxrxreset_i                            <= gtxtxreset_i or gtxrxreset_i;
    gtx1_gtxtxreset_i                            <= gtxtxreset_i or gtxrxreset_i;
    gtx1_gtxrxreset_i                            <= gtxtxreset_i or gtxrxreset_i;

    -- Shared VIO Outputs
    gtxtxreset_i                                 <= shared_vio_out_i(31);
    gtxrxreset_i                                 <= shared_vio_out_i(30);
    user_tx_reset_i                              <= shared_vio_out_i(29);
    user_rx_reset_i                              <= shared_vio_out_i(28);
    mux_sel_i                                    <= shared_vio_out_i(27);

    -- Shared VIO Inputs
    shared_vio_in_i(31 downto 0)                 <= "00000000000000000000000000000000";

    -- Chipscope connections on GTX 0
    gtx0_tx_data_vio_async_in_i(31)              <= '0';
    gtx0_tx_data_vio_async_in_i(30)              <= gtx0_txresetdone_i;
    gtx0_tx_data_vio_async_in_i(29 downto 0)     <= "000000000000000000000000000000";
    gtx0_tx_data_vio_sync_in_i(31 downto 0)      <= "00000000000000000000000000000000";
    gtx0_txpllrefseldy_i                         <= tx_data_vio_async_out_i(30 downto 28);
    gtx0_loopback_i                              <= tx_data_vio_async_out_i(27 downto 25);
    gtx0_txdiffctrl_i                            <= tx_data_vio_async_out_i(24 downto 21);
    gtx0_txpreemphasis_i                         <= tx_data_vio_async_out_i(20 downto 17);
    gtx0_txpostemphasis_i                        <= tx_data_vio_async_out_i(16 downto 12);
    gtx0_txpolarity_i                            <= tx_data_vio_sync_out_i(31);
    gtx0_rx_data_vio_async_in_i(31)              <= gtx0_rxplllkdet_i;
    gtx0_rx_data_vio_async_in_i(30)              <= gtx0_rxresetdone_i;
    gtx0_rx_data_vio_async_in_i(29 downto 0)     <= "000000000000000000000000000000";
    gtx0_rx_data_vio_sync_in_i(31 downto 0)      <= "00000000000000000000000000000000";
    gtx0_pllrxreset_i                            <= rx_data_vio_async_out_i(31);
    gtx0_rxpllrefseldy_i                         <= rx_data_vio_async_out_i(30 downto 28);
    gtx0_rxeqmix_i                               <= rx_data_vio_async_out_i(27 downto 25);
    gtx0_rxpolarity_i                            <= rx_data_vio_sync_out_i(31);
    gtx0_ila_in_i(84)                            <= gtx0_rxcharisk_i;
    gtx0_ila_in_i(83)                            <= gtx0_rxdisperr_i;
    gtx0_ila_in_i(82)                            <= gtx0_rxnotintable_i;
    gtx0_ila_in_i(81 downto 79)                  <= gtx0_rxclkcorcnt_i;
    gtx0_ila_in_i(78)                            <= gtx0_rxcommadet_i;
    gtx0_ila_in_i(77 downto 70)                  <= gtx0_rxdata_i;
    gtx0_ila_in_i(69 downto 62)                  <= gtx0_error_count_i;
    gtx0_ila_in_i(61 downto 0)                   <= "00000000000000000000000000000000000000000000000000000000000000";

    -- Chipscope connections on GTX 1
    gtx1_tx_data_vio_async_in_i(31)              <= '0';
    gtx1_tx_data_vio_async_in_i(30)              <= gtx1_txresetdone_i;
    gtx1_tx_data_vio_async_in_i(29 downto 0)     <= "000000000000000000000000000000";
    gtx1_tx_data_vio_sync_in_i(31 downto 0)      <= "00000000000000000000000000000000";
    gtx1_txpllrefseldy_i                         <= tx_data_vio_async_out_i(30 downto 28);
    gtx1_loopback_i                              <= tx_data_vio_async_out_i(27 downto 25);
    gtx1_txdiffctrl_i                            <= tx_data_vio_async_out_i(24 downto 21);
    gtx1_txpreemphasis_i                         <= tx_data_vio_async_out_i(20 downto 17);
    gtx1_txpostemphasis_i                        <= tx_data_vio_async_out_i(16 downto 12);
    gtx1_txpolarity_i                            <= tx_data_vio_sync_out_i(31);
    gtx1_rx_data_vio_async_in_i(31)              <= gtx1_rxplllkdet_i;
    gtx1_rx_data_vio_async_in_i(30)              <= gtx1_rxresetdone_i;
    gtx1_rx_data_vio_async_in_i(29 downto 0)     <= "000000000000000000000000000000";
    gtx1_rx_data_vio_sync_in_i(31 downto 0)      <= "00000000000000000000000000000000";
    gtx1_pllrxreset_i                            <= rx_data_vio_async_out_i(31);
    gtx1_rxpllrefseldy_i                         <= rx_data_vio_async_out_i(30 downto 28);
    gtx1_rxeqmix_i                               <= rx_data_vio_async_out_i(27 downto 25);
    gtx1_rxpolarity_i                            <= rx_data_vio_sync_out_i(31);
    gtx1_ila_in_i(84)                            <= gtx1_rxcharisk_i;
    gtx1_ila_in_i(83)                            <= gtx1_rxdisperr_i;
    gtx1_ila_in_i(82)                            <= gtx1_rxnotintable_i;
    gtx1_ila_in_i(81 downto 79)                  <= gtx1_rxclkcorcnt_i;
    gtx1_ila_in_i(78)                            <= gtx1_rxcommadet_i;
    gtx1_ila_in_i(77 downto 70)                  <= gtx1_rxdata_i;
    gtx1_ila_in_i(69 downto 62)                  <= gtx1_error_count_i;
    gtx1_ila_in_i(61 downto 0)                   <= "00000000000000000000000000000000000000000000000000000000000000";


    --Mux inputs to Chipscope modules based on mux_sel_i

    tx_data_vio_async_in_i              <=      gtx0_tx_data_vio_async_in_i when (mux_sel_i = '0')
                                        else    gtx1_tx_data_vio_async_in_i;


    tx_data_vio_sync_in_i               <=      gtx0_tx_data_vio_sync_in_i when (mux_sel_i = '0')
                                        else    gtx1_tx_data_vio_sync_in_i;

    rx_data_vio_async_in_i              <=      gtx0_rx_data_vio_async_in_i when (mux_sel_i = '0')
                                        else    gtx1_rx_data_vio_async_in_i;


    rx_data_vio_sync_in_i               <=      gtx0_rx_data_vio_sync_in_i when (mux_sel_i = '0')
                                        else    gtx1_rx_data_vio_sync_in_i;


    ila_in_i                            <=      gtx0_ila_in_i when (mux_sel_i = '0')
                                        else    gtx1_ila_in_i;


end generate chipscope;


no_chipscope : if EXAMPLE_USE_CHIPSCOPE = 0 generate

    -- If Chipscope is not being used, drive GTX reset signal
    -- from the top level ports
    gtx0_gtxtxreset_i                            <= GTXTXRESET_IN;
    gtx0_gtxrxreset_i                            <= GTXRXRESET_IN;
    gtx1_gtxtxreset_i                            <= GTXTXRESET_IN;
    gtx1_gtxrxreset_i                            <= GTXRXRESET_IN;

    -- assign resets for frame_gen modules
    gtx0_tx_system_reset_c                       <= not gtx0_txresetdone_r2;
    gtx1_tx_system_reset_c                       <= not gtx1_txresetdone_r2;
    -- assign resets for frame_check modules
    gtx0_rx_system_reset_c                       <= not gtx0_rxresetdone_r3;
    gtx1_rx_system_reset_c                       <= not gtx1_rxresetdone_r3;

    gtxtxreset_i                                 <= tied_to_ground_i;
    gtxrxreset_i                                 <= tied_to_ground_i;
    user_tx_reset_i                              <= tied_to_ground_i;
    user_rx_reset_i                              <= tied_to_ground_i;
    mux_sel_i                                    <= tied_to_ground_i;
    gtx0_txpllrefseldy_i                         <= tied_to_ground_vec_i(2 downto 0);
    gtx0_loopback_i                              <= tied_to_ground_vec_i(2 downto 0);
    gtx0_txdiffctrl_i                            <= "1010";
    gtx0_txpreemphasis_i                         <= tied_to_ground_vec_i(3 downto 0);
    gtx0_txpostemphasis_i                        <= tied_to_ground_vec_i(4 downto 0);
    gtx0_txpolarity_i                            <= tied_to_ground_i;
    gtx0_pllrxreset_i                            <= tied_to_ground_i;
    gtx0_rxpllrefseldy_i                         <= tied_to_ground_vec_i(2 downto 0);
    gtx0_rxeqmix_i                               <= tied_to_ground_vec_i(2 downto 0);
    gtx0_rxpolarity_i                            <= tied_to_ground_i;
    gtx1_txpllrefseldy_i                         <= tied_to_ground_vec_i(2 downto 0);
    gtx1_loopback_i                              <= tied_to_ground_vec_i(2 downto 0);
    gtx1_txdiffctrl_i                            <= "1010";
    gtx1_txpreemphasis_i                         <= tied_to_ground_vec_i(3 downto 0);
    gtx1_txpostemphasis_i                        <= tied_to_ground_vec_i(4 downto 0);
    gtx1_txpolarity_i                            <= tied_to_ground_i;
    gtx1_pllrxreset_i                            <= tied_to_ground_i;
    gtx1_rxpllrefseldy_i                         <= tied_to_ground_vec_i(2 downto 0);
    gtx1_rxeqmix_i                               <= tied_to_ground_vec_i(2 downto 0);
    gtx1_rxpolarity_i                            <= tied_to_ground_i;



end generate no_chipscope;


end RTL;


