-- file: ip_dac_data_output.vhd
-- (c) Copyright 2009 - 2011 Xilinx, Inc. All rights reserved.
-- 
-- This file contains confidential and proprietary information
-- of Xilinx, Inc. and is protected under U.S. and
-- international copyright and other intellectual property
-- laws.
-- 
-- DISCLAIMER
-- This disclaimer is not a license and does not grant any
-- rights to the materials distributed herewith. Except as
-- otherwise provided in a valid license issued to you by
-- Xilinx, and to the maximum extent permitted by applicable
-- law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
-- WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
-- AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
-- BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
-- INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
-- (2) Xilinx shall not be liable (whether in contract or tort,
-- including negligence, or under any other theory of
-- liability) for any loss or damage of any kind or nature
-- related to, arising under or in connection with these
-- materials, including for any direct, or any indirect,
-- special, incidental, or consequential loss or damage
-- (including loss of data, profits, goodwill, or any type of
-- loss or damage suffered as a result of any action brought
-- by a third party) even if such damage or loss was
-- reasonably foreseeable or Xilinx had been advised of the
-- possibility of the same.
-- 
-- CRITICAL APPLICATIONS
-- Xilinx products are not designed or intended to be fail-
-- safe, or for use in any application requiring fail-safe
-- performance, such as life-support or safety devices or
-- systems, Class III medical devices, nuclear facilities,
-- applications related to the deployment of airbags, or any
-- other applications that could lead to death, personal
-- injury, or severe property or environmental damage
-- (individually and collectively, "Critical
-- Applications"). Customer assumes the sole risk and
-- liability of any use of Xilinx products in Critical
-- Applications, subject only to applicable laws and
-- regulations governing limitations on product liability.
-- 
-- THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
-- PART OF THIS FILE AT ALL TIMES.
------------------------------------------------------------------------------
-- User entered comments
------------------------------------------------------------------------------
-- None
------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_misc.all;
use ieee.numeric_std.all;

library unisim;
use unisim.vcomponents.all;

entity ip_dac_data_output is
generic
 (-- width of the data for the system
  sys_w       : integer := 16;
  -- width of the data for the device
  dev_w       : integer := 16);
port
 (
  -- From the device out to the system
  DATA_OUT_FROM_DEVICE    : in    std_logic_vector(dev_w-1 downto 0);
  DATA_OUT_TO_PINS_P      : out   std_logic_vector(sys_w-1 downto 0);
  DATA_OUT_TO_PINS_N      : out   std_logic_vector(sys_w-1 downto 0);

-- Input, Output delay control signals
  DELAY_CLK            : in    std_logic;
  DELAY_RESET          : in    std_logic;                    -- Active high synchronous reset for input delay
  DELAY_DATA_CE        : in    std_logic_vector(sys_w -1 downto 0);            -- Enable signal for delay for bit 
  DELAY_DATA_INC       : in    std_logic_vector(sys_w -1 downto 0);            -- Delay increment, decrement signal for bit 
  DELAY_LOCKED            : out   std_logic;                    -- Locked signal from IDELAYCTRL
  REF_CLOCK               : in    std_logic;                    -- Reference Clock for IDELAYCTRL. Has to come from BUFG.
 
-- Clock and reset signals
  CLK_IN                  : in    std_logic;                    -- Fast clock from PLL/MMCM 
  IO_RESET                : in    std_logic);                   -- Reset signal for IO circuit
end ip_dac_data_output;

architecture xilinx of ip_dac_data_output is
  attribute CORE_GENERATION_INFO            : string;
  attribute CORE_GENERATION_INFO of xilinx  : architecture is "ip_dac_data_output,selectio_wiz_v4_1,{component_name=ip_dac_data_output,bus_dir=OUTPUTS,bus_sig_type=DIFF,bus_io_std=LVDS_25,use_serialization=false,use_phase_detector=false,serialization_factor=4,enable_bitslip=false,enable_train=false,system_data_width=16,bus_in_delay=NONE,bus_out_delay=NONE,clk_sig_type=DIFF,clk_io_std=LVCMOS18,clk_buf=BUFIO2,active_edge=RISING,clk_delay=NONE,v6_bus_in_delay=NONE,v6_bus_out_delay=VARIABLE,v6_clk_buf=MMCM,v6_active_edge=SDR,v6_ddr_alignment=SAME_EDGE_PIPELINED,v6_oddr_alignment=SAME_EDGE,ddr_alignment=C0,v6_interface_type=NETWORKING,interface_type=NETWORKING,v6_bus_in_tap=0,v6_bus_out_tap=0,v6_clk_io_std=LVDS_25,v6_clk_sig_type=DIFF}";
  constant clock_enable            : std_logic := '1';
  signal unused : std_logic;
  signal clk_in_int                : std_logic;
  signal clk_in_int_buf            : std_logic;
  signal clk_gclk_in_int           : std_logic;


  -- Before the buffer
  signal data_out_to_pins_int      : std_logic_vector(sys_w-1 downto 0);
  -- Between the delay and serdes
  signal data_out_to_pins_predelay : std_logic_vector(sys_w-1 downto 0);
  signal data_delay                : std_logic_vector(sys_w-1 downto 0); 
  signal delay_ce              : std_logic_vector(sys_w-1 downto 0);
  signal delay_inc_dec         : std_logic_vector(sys_w-1 downto 0);
  signal data_out_from_device_q    : std_logic_vector(dev_w-1 downto 0) ;

  attribute IODELAY_GROUP : string;
  attribute IODELAY_GROUP of delayctrl : label is "ip_dac_data_output_group";

begin

  delay_ce <=               DELAY_DATA_CE(15) &
              DELAY_DATA_CE(14) &
              DELAY_DATA_CE(13) &
              DELAY_DATA_CE(12) &
              DELAY_DATA_CE(11) &
              DELAY_DATA_CE(10) &
              DELAY_DATA_CE(9) &
              DELAY_DATA_CE(8) &
              DELAY_DATA_CE(7) &
              DELAY_DATA_CE(6) &
              DELAY_DATA_CE(5) &
              DELAY_DATA_CE(4) &
              DELAY_DATA_CE(3) &
              DELAY_DATA_CE(2) &
              DELAY_DATA_CE(1) &
              DELAY_DATA_CE(0);
  delay_inc_dec <=                DELAY_DATA_INC(15) &
               DELAY_DATA_INC(14) &
               DELAY_DATA_INC(13) &
               DELAY_DATA_INC(12) &
               DELAY_DATA_INC(11) &
               DELAY_DATA_INC(10) &
               DELAY_DATA_INC(9) &
               DELAY_DATA_INC(8) &
               DELAY_DATA_INC(7) &
               DELAY_DATA_INC(6) &
               DELAY_DATA_INC(5) &
               DELAY_DATA_INC(4) &
               DELAY_DATA_INC(3) &
               DELAY_DATA_INC(2) &
               DELAY_DATA_INC(1) &
               DELAY_DATA_INC(0);



  -- Create the clock logic
   clk_in_int_buf <= CLK_IN;

  
  -- We have multiple bits- step over every bit, instantiating the required elements
  pins: for pin_count in 0 to sys_w-1 generate
     attribute IODELAY_GROUP of iodelaye1_bus: label is "ip_dac_data_output_group";
   attribute IOB : string;
   attribute IOB of fdre_out_inst : label is "true";
  begin
    -- Instantiate the buffers
    ----------------------------------
    -- Instantiate a buffer for every bit of the data bus
     obufds_inst : OBUFDS
       generic map (
         IOSTANDARD => "LVDS_25")
       port map (
         O          => DATA_OUT_TO_PINS_P  (pin_count),
         OB         => DATA_OUT_TO_PINS_N  (pin_count),
         I          => data_out_to_pins_int(pin_count));

    -- Instantiate the delay primitive
    -----------------------------------

     iodelaye1_bus : IODELAYE1
       generic map (
         CINVCTRL_SEL           => FALSE,            -- TRUE, FALSE
         DELAY_SRC              => "O",              -- I, IO, O, CLKIN, DATAIN
         HIGH_PERFORMANCE_MODE  => TRUE,             -- TRUE, FALSE
         IDELAY_TYPE            => "FIXED",          -- Has to be set to FIXED when IODELAYE1 is configured for Output
         IDELAY_VALUE           => 0,                -- Set to 0 as IODELAYE1 is configured for Output
         ODELAY_TYPE            => "VARIABLE",          -- FIXED, VARIABLE, or VAR_LOADABLE
         ODELAY_VALUE           => 0,              -- 0 to 31
         REFCLK_FREQUENCY       => 200.0,
         SIGNAL_PATTERN         => "DATA"           -- CLOCK, DATA
         )
       port map (
         DATAOUT                => data_delay (pin_count),
         DATAIN                 => '0', -- Data from FPGA logic
         C                      => DELAY_CLK,
         CE                     => delay_ce(pin_count), --DELAY_DATA_CE,
         INC                    => delay_inc_dec(pin_count), --DELAY_DATA_INC,
         IDATAIN                => '0',
         ODATAIN                => data_out_to_pins_predelay(pin_count), -- Driven by OLOGIC/OSERDES
         RST                    => DELAY_RESET,
         T                      => '0',
         CNTVALUEIN             => "00000",
         CNTVALUEOUT            => open,
         CLKIN                  => '0',
         CINVCTRL               => '0'
         );

 
           data_out_to_pins_int(pin_count) <= data_delay(pin_count);




    -- Connect the delayed data to the fabric
    ------------------------------------------

    -- Pack the registers into the IOB
    fdre_out_inst : FDRE
      port map
       (D             => DATA_OUT_FROM_DEVICE(pin_count),
        C             => clk_in_int_buf,
        CE            => clock_enable,
        R             => IO_RESET,
        Q             => data_out_from_device_q(pin_count));
     data_out_to_pins_predelay(pin_count) <= data_out_from_device_q(pin_count);

  end generate pins;

-- IDELAYCTRL is needed for calibration
delayctrl : IDELAYCTRL
    port map (
     RDY    => DELAY_LOCKED,
     REFCLK => REF_CLOCK,
     RST    => IO_RESET
     );




end xilinx;



