/* $ZEL: sis1100_init_remote.c,v 1.11.2.2 2002/11/21 13:02:29 wuestner Exp $ */

#include "Copyright"

#include <linux/config.h>
#include <linux/module.h>
#include <linux/pci.h>

#include <dev/pci/sis1100_sc.h>

void
sis1100_synch_s_handler(void* data)
{
    struct SIS1100_softc* sc=(struct SIS1100_softc*)data;
    u_int32_t status;

/* reenable IRQs, but not sis1100irq_prot_end */
    sis1100_enable_irq(sc, 0, irq_synch_chg|irq_reset_req|irq_prot_l_err);
    status=sis1100readreg(sc, sr);

    printk(KERN_INFO "SIS1100[%d]: synch_s_handler: status=0x%08x\n",
        sc->unit, status);

    if ((status&sr_synch)==sr_synch) sis1100_init_remote(sc);
}

void
sis1100_synch_handler(unsigned long data)
{
    struct SIS1100_softc* sc=(struct SIS1100_softc*)data;
    int res;
/*
    printk(KERN_NOTICE "SIS1100[%d]: synch_handler called\n");
*/
    res=schedule_task(&sc->link_up_task);
    if (!res) printk(KERN_NOTICE
        "SIS1100[%d]: sis1100_synch_s_handler not scheduled\n", sc->unit);
}

static int sharc_present(struct SIS1100_softc* sc)
{
    u_int32_t dsp_sc;
    int res;

    res=sis3100readreg(sc, dsp_sc, &dsp_sc, 0);
    if (res) {
        printk(KERN_INFO "SIS1100[%d]: read dsp_sc: res=%d\n", sc->unit, res);
        return 0;
    }
    return !!(dsp_sc&dsp_available);
}

char* rnames[]={"PCI", "VME", "CAMAC"};

void
sis1100_init_remote(struct SIS1100_softc* sc)
{
#define MIN_FV 3
#define MAX_FV 5
    u_int32_t error, balance, typ, hv, fk, fv, stat;

    down(&sc->sem_hw);

    /*sis1100writereg(sc, cr, cr_rem_reset);*/ /* reset remote */
    flush_fifo(sc, "init_remote" , 0); /* clear local fifo */
    sis1100writereg(sc, p_balance, 0);
    sis1100readreg(sc, prot_error);

    sc->remote_ident=plxreadlocal0(sc, 0x800);
    error=sis1100readreg(sc, prot_error);
    balance=sis1100readreg(sc, p_balance);
    up(&sc->sem_hw);

    if (error || balance) {
        printk(KERN_ERR "SIS1100[%d]: error reading remote ident\n", sc->unit);
        printk(KERN_ERR "error=0x%x balance=%d\n", error, balance);
        flush_fifo(sc, "after reading ident" , 0); /* clear local fifo */
        /*dump_glink_status(sc, "init remote");*/
        return;
    }

    typ=sc->remote_ident&0xff;
    hv=(sc->remote_ident>>8)&0xff;
    fk=(sc->remote_ident>>16)&0xff;
    fv=(sc->remote_ident>>24)&0xff;
    printk(KERN_INFO "SIS1100[%d]:%s: remote ident: 0x%08x\n",
            sc->unit, sc->pcidev->slot_name, sc->remote_ident);
    if ((typ>0) && (typ<4))
        printk(KERN_INFO "SIS1100[%d]:%s: remote is %s\n",
                sc->unit, sc->pcidev->slot_name, rnames[typ-1]);
    else
        printk(KERN_ERR "SIS1100[%d]:%s: unknown remote type %d\n",
                sc->unit, sc->pcidev->slot_name, typ);
    printk(KERN_INFO "SIS1100[%d]: remote HW_ver %d FW_code %d FW_ver %d\n",
                sc->unit, hv, fk, fv);

    switch (sc->remote_ident&0xffffff) { /* type, HW version and FW code */
        case 0x010102: {
            if (fv<MIN_FV) {
                printk(KERN_ERR "SIS1100[%d]: remote firmware version too old;"
                        " at least version %d is required.\n",
                        sc->unit, MIN_FV);
                return;
            }
            if (fv>MAX_FV) {
                printk(KERN_WARNING "SIS1100[%d]: Driver not tested with"
                        " remote firmware versions greater than %d.\n",
                        sc->unit, MAX_FV);
            }
        } break;
        case 0x010103: {
            printk(KERN_ERR "SIS CAMAC Controller is not supported yet.\n"
                "  please ask for a driver version 2.+\n");
            return;
        } break;
        default:
            printk(KERN_ERR "SIS1100[%d]: remote: unknown remote device\n",
                    sc->unit);
            return;
    }

    if (init_sdram(sc)<0)
        return;
    printk(KERN_INFO "SIS1100[%d]: size of SDRAM: 0x%Lx (%Ld MByte)\n",
        sc->unit, sc->sdram_size, sc->sdram_size>>20);

    sc->sharc_present=sharc_present(sc);
    sc->sharc_size=sc->sharc_present?0x400000:0;
    printk(KERN_INFO "SIS1100[%d]: SHARC is %spresent\n",
        sc->unit, sc->sharc_present?"":"not ");

    down(&sc->sem_hw);
    plxwritelocal0(sc, 0x800+0x104, 0x00fe0001);
    stat=plxreadlocal0(sc, 0x800+0x100);
    up(&sc->sem_hw);
    if (!(stat&0x10000)) {
        printk(KERN_WARNING "SIS1100[%d]: System Controller NOT enabled!\n",
            sc->unit);
    }

    sc->old_remote_ok=sc->remote_ok;
    sc->remote_ok=1;
    schedule_task(&sc->vme_irq_task);
#undef MIN_FV
#undef MAX_FV
}
