/* $ZEL: sis1100_var.h,v 1.4.2.2 2002/11/21 13:02:26 wuestner Exp $ */

/*
 * Copyright (c) 2001
 * 	Peter Wuestner.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _sis1100_var_h_
#define _sis1100_var_h_

#define SIS1100_MinVersion 2
#define SIS1100_MajVersion 1
#define SIS1100_Version (SIS1100_MinVersion|(SIS1100_MajVersion<<16))

#include "linux/ioctl.h"

struct sis1100_mapinfo {
  int space;
  loff_t offset;
  size_t size;
};

struct sis1100_vme_req {
    int size;
    int32_t am;
    u_int32_t addr;
    u_int32_t data;
    u_int32_t error;
};

struct sis1100_vme_block_req {
    int size;        /* size of dataword */
    int fifo;
    size_t num;      /* number of datawords */
    int32_t am;
    u_int32_t addr;  /* remote bus address */
    u_int32_t* data; /* local user space address */
    u_int32_t error;
};

struct sis1100_vme_super_block_req {
    int n;
    struct sis1100_vme_block_req* reqs;
};

struct sis1100_pipelist {
    u_int32_t head; /* masked with 0xff3f0400:                */
    	    	    /* only be, remote space and w/r are used */
    int32_t am;
    u_int32_t addr;
    u_int32_t data; /* only used for write access */
};

struct sis1100_pipe {
    int num;
    struct sis1100_pipelist* list;
    u_int32_t* data;
    u_int32_t error;
};

struct sis1100_readpipe {
    int num;
    int am;
    int size;
    u_int32_t* list;
    u_int32_t* data;
    u_int32_t error;
};

struct vmespace {
    int32_t am;
    u_int32_t datasize;
    int swap;         /* not (yet) used; always big endian */
    int mapit;        /* not used */
    ssize_t mindmalen; /* 0: never use DMA; 1: always use DMA; -1: not changed */
};

struct sis1100_ident_dev {
    int hw_type;
    int hw_version;
    int fw_type;
    int fw_version;
};

struct sis1100_ident {
    struct sis1100_ident_dev local;
    struct sis1100_ident_dev remote;
    int remote_ok;
    int remote_online;
};

struct sis1100_ctrl_reg {
    int offset;
    u_int32_t val;
    u_int32_t error;
};

struct sis1100_irq_ctl {
    u_int32_t irq_mask;
    int signal;
};

struct sis1100_irq_get {
    u_int32_t irq_mask;
    int immediate_ack;
    int remote_status; /* -1: down 1: up 0: unchanged */
    u_int32_t irqs;
    int level;
    int32_t vector;
};

struct sis1100_irq_ack {
    u_int32_t irq_mask;
};

#define SIS3100_VME_IRQS      0xFE
#define SIS3100_FLAT_IRQS    0xF00
#define SIS3100_LEMO_IRQS   0x7000
#define SIS3100_DSP_IRQ     0x8000
#define SIS3100_FRONT_IRQS (SIS3100_FLAT_IRQS  | SIS3100_LEMO_IRQS)
#define SIS3100_EXT_IRQS   (SIS3100_FRONT_IRQS | SIS3100_DSP_IRQ  )
#define SIS3100_IRQS       (SIS3100_VME_IRQS   | SIS3100_EXT_IRQS )

#define SIS1100_FRONT_IRQS 0x30000
#define SIS1100_IRQS SIS1100_FRONT_IRQS

#define GLINK_MAGIC 'g'

#define SIS1100_SETVMESPACE     _IOW(GLINK_MAGIC,  1, struct vmespace)
#define SIS3100_VME_PROBE       _IOW(GLINK_MAGIC,  2, u_int32_t)
#define SIS3100_VME_READ        _IOWR(GLINK_MAGIC, 3, struct sis1100_vme_req)
#define SIS3100_VME_WRITE       _IOWR(GLINK_MAGIC, 4, struct sis1100_vme_req)
#define SIS3100_VME_BLOCK_READ  _IOWR(GLINK_MAGIC, 5, struct sis1100_vme_block_req)
#define SIS3100_VME_BLOCK_WRITE _IOWR(GLINK_MAGIC, 6, struct sis1100_vme_block_req)
#define SIS1100_CONTROL_READ    _IOWR(GLINK_MAGIC, 7, struct sis1100_ctrl_reg)
#define SIS1100_CONTROL_WRITE   _IOWR(GLINK_MAGIC, 8, struct sis1100_ctrl_reg)
#define SIS3100_CONTROL_READ    _IOWR(GLINK_MAGIC, 9, struct sis1100_ctrl_reg)
#define SIS3100_CONTROL_WRITE   _IOWR(GLINK_MAGIC, 10, struct sis1100_ctrl_reg)
#define SIS1100_PIPE            _IOWR(GLINK_MAGIC, 11, struct sis1100_pipe)
#define SIS1100_MAPINFO         _IOWR(GLINK_MAGIC, 12, struct sis1100_mapinfo)
#define SIS1100_LAST_ERROR      _IOR(GLINK_MAGIC,  13, u_int32_t)
#define SIS1100_IDENT           _IOR(GLINK_MAGIC,  14, struct sis1100_ident)
#define SIS1100_FIFOMODE        _IOWR(GLINK_MAGIC, 15, int)
/*
#define SIS1100_BIGENDIAN       _IOWR(GLINK_MAGIC, 16, int)
*/
#define SIS1100_IRQ_CTL         _IOW(GLINK_MAGIC,  17, struct sis1100_irq_ctl)
#define SIS1100_IRQ_GET         _IOWR(GLINK_MAGIC, 18, struct sis1100_irq_get)
#define SIS1100_IRQ_ACK         _IOW(GLINK_MAGIC,  19, struct sis1100_irq_ack)
#define SIS1100_IRQ_WAIT        _IOWR(GLINK_MAGIC, 20, struct sis1100_irq_get)

#define SIS1100_MINDMALEN       _IOWR(GLINK_MAGIC, 21, int[2])

#define SIS1100_FRONT_IO        _IOWR(GLINK_MAGIC, 22, u_int32_t)
#define SIS1100_FRONT_PULSE     _IOW(GLINK_MAGIC,  23, u_int32_t)
#define SIS1100_FRONT_LATCH     _IOWR(GLINK_MAGIC, 24, u_int32_t)

#define SIS3100_VME_SUPER_BLOCK_READ  _IOWR(GLINK_MAGIC, 25, struct sis1100_vme_super_block_req)

#define SIS1100_CLEAR_USE_COUNT _IO(GLINK_MAGIC,  101)
#define SIS1100_DUMP            _IO(GLINK_MAGIC,  102)
#define SIS3100_RESET           _IO(GLINK_MAGIC,  103)
#define SIS1100_DEVTYPE         _IOR(GLINK_MAGIC, 104, int)

#ifndef PURE_SIS1100_NAMESPACE
#define SETVMESPACE SIS1100_SETVMESPACE
#define VME_PROBE SIS3100_VME_PROBE
#endif

#if 0
0x08 A32 non privileged 64-bit block transfer
0x09 A32 non privileged data access
0x0B A32 non privileged block transfer
0x0C A32 supervisory 64-bit block transfer
0x0D A32 supervisory data access
0x0F A32 supervisory block transfer
0x29 A16 non privileged access
0x2D A16 supervisory access
0x38 A24 non privileged 64-bit block transfer
0x39 A24 non privileged data access
0x3B A24 non privileged block transfer
0x3C A24 supervisory 64-bit block transfer
0x3D A24 supervisory data access
0x3F A24 supervisory block transfer
#endif

#endif
