#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <sys/ioctl.h>

#include "dev/pci/sis1100_var.h"
#include "sis3100_vme_calls.h"



/*===========================================================================*/
/* Globals					  			     */
/*===========================================================================*/

#define MAX_NUMBER_OF_PRINTS 0x10      
#define MAX_NUMBER_LWORDS 0x400000       /* 16MByte */

u_int32_t rblt_data[MAX_NUMBER_LWORDS] ;



/*===========================================================================*/
/* Prototypes					  			     */
/*===========================================================================*/



/****************************************************************************/
int main(int argc, char* argv[])
{


int p_sdram;
u_int32_t no_of_mbytes ;
u_int32_t no_of_lwords ;
u_int32_t sdram_start_addr, addr ;

int return_code ;
int i, i_no_of_mbyte;

/*
int i;
*/
int loop_cnt ;
int no_loops ;


/* open SDRAM */
   if ((p_sdram=open("/tmp/sis3100sdram", O_RDWR, 0))<0) {
     printf("error on sdram open");
     return -1;
   }

if (argc<2)
  {
   printf("usage:  NO_OF_MBYTES  [NO_OF_LOOPS]\n");
  return -1;
  }

no_of_mbytes = strtoul(argv[1],NULL,0) ;

no_loops = 0x1 ;
if (argc>2)
  {
    no_loops = strtoul(argv[2],NULL,0) ;
  }

 
loop_cnt = 0x0 ;
do
 {

    no_of_lwords =  0x40000  ;  /* 1 MBYTE */  
    for (i_no_of_mbyte=0; i_no_of_mbyte<no_of_mbytes; i_no_of_mbyte++)  {
       sdram_start_addr = (i_no_of_mbyte * 0x100000);                     
       return_code = s3100_sdram_read(p_sdram, sdram_start_addr, rblt_data, no_of_lwords) ;
       if (return_code != (no_of_lwords*4)) {
          printf("s3100_sdram_read:  return_code = 0x%08x  at address = 0x%08x\n", return_code, sdram_start_addr );         
          return -1 ;
        }
     }


    loop_cnt = loop_cnt + 1 ;

} while ((return_code >= 0) && (loop_cnt != no_loops)) ;

  printf(" loop counter = 0x%08x \n ", loop_cnt);


close(p_sdram);

return 0 ;
}





#ifdef tino


/***************************************************/
      
int sdram_test_inc_mbytes(int ip_sdram, u_int32_t start_value, int no_of_MBytes) 

{

u_int32_t sdram_start_addr, addr ;
u_int32_t no_of_lwords ;

int i, i_no_of_mbyte;
int error_cnt ;
int return_code ;


    /* SDRAM write data */
    no_of_lwords =  0x40000  ;  /* 1 MBYTE */  
    for (i_no_of_mbyte=0; i_no_of_mbyte<no_of_MBytes; i_no_of_mbyte++)  {

       for (i=0;i<no_of_lwords;i++)    { wblt_data[i] = (i_no_of_mbyte * 0x40000) + i + start_value; }
       sdram_start_addr = (i_no_of_mbyte * 0x100000);                     
       return_code = s3100_sdram_write(ip_sdram, sdram_start_addr, wblt_data, no_of_lwords) ;  /* 1 MBYTE */
       if (return_code != (no_of_lwords*4)) {
          printf("s3100_sdram_write:  return_code = 0x%08x  at address = 0x%08x\n", return_code, sdram_start_addr );         
          return -1 ;
        }
     }

    /* read and check */
    no_of_lwords =  0x40000  ;  /* 1 MBYTE */  
    for (i_no_of_mbyte=0; i_no_of_mbyte<no_of_MBytes; i_no_of_mbyte++)  {

       sdram_start_addr = (i_no_of_mbyte * 0x100000);                     
       return_code = s3100_sdram_read(ip_sdram, sdram_start_addr, rblt_data, no_of_lwords) ;
       if (return_code != (no_of_lwords*4)) {
          printf("s3100_sdram_read:  return_code = 0x%08x  at address = 0x%08x\n", return_code, sdram_start_addr );         
          return -1 ;
        }
       for (i=0;i<no_of_lwords;i++)  {
         if (((i_no_of_mbyte * 0x40000) + i + start_value) != rblt_data[i])  
           {
             printf(" Error at i = : 0x%08x    written = : 0x%08x   read = : 0x%08x\n", i, 
             ((i_no_of_mbyte * 0x40000) + i + start_value), rblt_data[i]);
             error_cnt = error_cnt + 1;
             if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
           }
         }
     }



error_cnt = 0 ;

  if (error_cnt == 0) {
     return 0 ; }
    else {
     return -1 ;}

}



#endif




























