#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <sys/ioctl.h>
#include <signal.h>

#include "dev/pci/sis1100_var.h"

/****************************************************************************/
static void sighnd(int sig)
{
    fprintf(stderr, "got sig %d\n", sig);
}
/****************************************************************************/
int main(int argc, char* argv[])
{
    int p;
    unsigned int out_value ;
    struct sigaction action;
    struct sis1100_irq_ctl irqctl;
    struct sis1100_irq_get irqget;
    struct sis1100_irq_ack irqack;
    sigset_t mask, old_mask;
    struct sis1100_ctrl_reg reg;

    if (argc!=2)
        {
        fprintf(stderr, "usage: %s path\n", argv[0]);
        return 1;
        }





    if ((p=open(argv[1], O_RDWR, 0))<0) return 1;

    out_value = 0x10 ;    
    if (ioctl(p, SIS1100_FRONT_IO, &out_value)<0) {
        perror("SIS1100_FRONT_IO");
        return -1;
      }

    out_value = 0x100000 ;    
    if (ioctl(p, SIS1100_FRONT_IO, &out_value)<0) {
        perror("SIS1100_FRONT_IO");
        return -1;
      }



    close(p);
    return 0;    
}
/****************************************************************************/
/****************************************************************************/


