#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <sys/ioctl.h>


#include "../dev/pci/sis1100_var.h"  
#include "../sis3100_calls/sis3100_vme_calls.h"

/*
#define swap_int(x) ((((x)>>24)&0x000000ff) |\
                     (((x)>> 8)&0x0000ff00) |\
                     (((x)<< 8)&0x00ff0000) |\
                     (((x)<<24)&0xff000000))

*/

#define SHARCRAM  0x01200000
#define D48REG    0x01300000


#define SDRAM_SCL    0x1
#define SDRAM_SDA    0x2
#define SDRAM_SDA_OE 0x4



#define swap_int(x)  ((((x)>>24)&0x000000ff) |\
                      (((x)>> 8)&0x0000ff00) |\
                      (((x)<< 8)&0x00ff0000) |\
                      (((x)<<24)&0xff000000))





int sdram_eeprom_stop (int p) ;
int sdram_eeprom_start (int p) ;
int sdram_eeprom_write (int p,  u_int32_t write_data) ;
int sdram_eeprom_read (int p,  u_int32_t* read_data) ;
int sdram_eeprom_read_noack (int p,  u_int32_t* read_data) ;


/****************************************************************************/

/****************************************************************************/
int main(int argc, char* argv[])
{
int i;
int p;
int p_sharc;
int offset ;
u_int32_t data ;
u_int32_t addr ;

int return_code ;


unsigned int tempword[0x10000];
int retcode=1;

int count=0 ;
int loadcount=0; 
int currentaddress ;

/*
int i;
char *dummy;
*/

if (argc<3)
  {
  fprintf(stderr, "usage: %s path (sis1100)  path2 (sis3100sharc)   \n", argv[0]);
  return 1;
  }

if ((p=open(argv[1], O_RDWR, 0))<0) {
	perror("open");
	return 1;
}

if ((p_sharc=open(argv[2], O_RDWR, 0))<0) {
	perror("open");
	return 1;
}


  printf("LED an \n");
  offset = 0x00000100;
  return_code = s3100_control_write(p, offset, 0x00000080) ; 
  if (return_code != 0) printf("s3100_control_write:   return_code = 0x%08x\n", return_code );         








  offset = 0x00000100;
  return_code = s3100_control_write(p, offset, 0x00000080) ; 
  if (return_code != 0) printf("s3100_control_write:   return_code = 0x%08x\n", return_code );         


#define SDRAM_SCL    0x1
#define SDRAM_SDA    0x2
#define SDRAM_SDA_OE 0x4


  addr = 0x40000400;

/* write test */

 sdram_eeprom_start (p_sharc) ;
 sdram_eeprom_write (p_sharc, 0xA0) ; /* device Write cmd  */
 sdram_eeprom_write (p_sharc, 0x90) ; /* write address */
 sdram_eeprom_write (p_sharc, 0x31) ; /* write data */
 sdram_eeprom_stop (p_sharc) ; 
 usleep(100000) ;

 sdram_eeprom_start (p_sharc) ;
 sdram_eeprom_write (p_sharc, 0xA0) ; /* device Write cmd  */
 sdram_eeprom_write (p_sharc, 0x91) ; /* write address */
 sdram_eeprom_write (p_sharc, 0x00) ; /* write data */
 sdram_eeprom_stop (p_sharc) ; 
 usleep(100000) ;





/* sdram_eeprom_stop (p_sharc) ; */
 sdram_eeprom_start (p_sharc) ;
 sdram_eeprom_write (p_sharc, 0xA0) ; /* device Write cmd  */
 sdram_eeprom_write (p_sharc, 0x00) ; /* write address */
/* sdram_eeprom_stop (p_sharc) ; */


 sdram_eeprom_start (p_sharc) ;

 sdram_eeprom_write (p_sharc, 0xA1) ; /* device Read cmd  */

  for (i=0;i<20;i++)
   {
     printf("i = %4d ", i * 8);      
     sdram_eeprom_read (p_sharc, &data) ;
     printf("    0x%02x ", data );      
     sdram_eeprom_read (p_sharc, &data) ;
     printf("    0x%02x ", data );      
     sdram_eeprom_read (p_sharc, &data) ;
     printf("    0x%02x ", data );      
     sdram_eeprom_read (p_sharc, &data) ;
     printf("    0x%02x  ", data );      
     sdram_eeprom_read (p_sharc, &data) ;
     printf("    0x%02x ", data );      
     sdram_eeprom_read (p_sharc, &data) ;
     printf("    0x%02x ", data );      
     sdram_eeprom_read (p_sharc, &data) ;
     printf("    0x%02x ", data );      
     sdram_eeprom_read (p_sharc, &data) ;
     printf("    0x%02x \n", data );      

   }

 sdram_eeprom_read_noack (p_sharc, &data) ;
 sdram_eeprom_stop (p_sharc) ;









  printf("LED aus \n");
  offset = 0x00000100;
  return_code = s3100_control_write(p, offset, 0x00800000) ; 
  if (return_code != 0) printf("s3100_control_write:   return_code = 0x%08x\n", return_code );         


close(p);
close(p_sharc);


return 0;
}






/***************************************************************************************************************/
/***************************************************************************************************************/

int sdram_eeprom_stop (int p)
{
  int return_code ;
  u_int32_t data ;
  u_int32_t addr ;

  addr = 0x40000400;

/* STOP:     */
  data = 0x0 ;
  return_code = s3100_sharc_write(p, addr, &data, 0x1) ;

  data = SDRAM_SDA_OE ; 
  return_code = s3100_sharc_write(p, addr, &data, 0x1) ;

  data = SDRAM_SDA_OE + SDRAM_SCL ; 
  return_code = s3100_sharc_write(p, addr, &data, 0x1) ;

  data = SDRAM_SDA_OE + SDRAM_SDA + SDRAM_SCL ; 
  return_code = s3100_sharc_write(p, addr, &data, 0x1) ;

  data = SDRAM_SDA_OE + SDRAM_SDA  ; 
  return_code = s3100_sharc_write(p, addr, &data, 0x1) ;

  data = 0x0 ;
  return_code = s3100_sharc_write(p, addr, &data, 0x1) ;

  return 0 ;
}



/***************************************************************************************************************/
/***************************************************************************************************************/

int sdram_eeprom_start (int p)
{
  int return_code ;
  u_int32_t data ;
  u_int32_t addr ;

  addr = 0x40000400;

/* START:     */
  data = 0x0 ;
  return_code = s3100_sharc_write(p, addr, &data, 0x1) ;

  data = SDRAM_SDA_OE + SDRAM_SDA ; 
  return_code = s3100_sharc_write(p, addr, &data, 0x1) ;

  data = SDRAM_SDA_OE + SDRAM_SDA + SDRAM_SCL ; 
  return_code = s3100_sharc_write(p, addr, &data, 0x1) ;

  data = SDRAM_SDA_OE + SDRAM_SCL ; 
  return_code = s3100_sharc_write(p, addr, &data, 0x1) ;

  data = SDRAM_SDA_OE ; 
  return_code = s3100_sharc_write(p, addr, &data, 0x1) ;
/*  printf("return_code = 0x%08x\n", return_code ); */

  data = 0x0 ;
  return_code = s3100_sharc_write(p, addr, &data, 0x1) ;

  return 0 ;
}



/***************************************************************************************************************/
/***************************************************************************************************************/

int sdram_eeprom_write (int p,  u_int32_t write_data)
{
  int return_code ;
  u_int32_t data ;
  u_int32_t help_data ;
  u_int32_t addr ;
  int i ;

  for (i=0;i<0x2000;i++)
   {
    addr = addr + i ;
   }

  addr = 0x40000400;

  help_data = write_data ;

  for (i=0;i<8;i++)
   {
     if ((write_data & 0x80) == 0x80) {
          data = SDRAM_SDA_OE + SDRAM_SDA  ; 
         }
         else {
          data = SDRAM_SDA_OE   ; 
         }  
      return_code = s3100_sharc_write(p, addr, &data, 0x1) ;

      data = data + SDRAM_SCL ;
      return_code = s3100_sharc_write(p, addr, &data, 0x1) ;
      data = data - SDRAM_SCL ;
      return_code = s3100_sharc_write(p, addr, &data, 0x1) ;
      write_data = write_data << 1 ;
   }

  data = 0x0 ;
  return_code = s3100_sharc_write(p, addr, &data, 0x1) ;

  data = SDRAM_SCL ; 
  return_code = s3100_sharc_write(p, addr, &data, 0x1) ;

  data = 0x0 ;
  return_code = s3100_sharc_write(p, addr, &data, 0x1) ;

  return 0 ;
}




/***************************************************************************************************************/
/***************************************************************************************************************/

int sdram_eeprom_read (int p,  u_int32_t* read_data)
{
  int return_code ;
  u_int32_t data ;
  u_int32_t help_data ;
  u_int32_t addr ;
  int i ;

  for (i=0;i<0x2000;i++)
   {
    addr = addr + i ;
   }

  addr = 0x40000400;

  help_data = 0 ;

  for (i=0;i<8;i++)
   {
      data = 0x0 ;
      return_code = s3100_sharc_write(p, addr, &data, 0x1) ;
      data = SDRAM_SCL ; 
      return_code = s3100_sharc_write(p, addr, &data, 0x1) ;

      return_code = s3100_sharc_read(p, addr, &data, 0x1) ;
      help_data = help_data << 1 ;
      help_data = help_data + ((data & 0x100) >> 8) ;  
   }

  *read_data =  help_data  ;

      data = SDRAM_SDA_OE ;
      return_code = s3100_sharc_write(p, addr, &data, 0x1) ;
      data = SDRAM_SDA_OE + SDRAM_SCL ; 
      return_code = s3100_sharc_write(p, addr, &data, 0x1) ;
      data = SDRAM_SDA_OE ;
      return_code = s3100_sharc_write(p, addr, &data, 0x1) ;
      data = 0x0 ;
      return_code = s3100_sharc_write(p, addr, &data, 0x1) ;

  return 0 ;
}

/***************************************************************************************************************/
/***************************************************************************************************************/

int sdram_eeprom_read_noack (int p,  u_int32_t* read_data)
{
  int return_code ;
  u_int32_t data ;
  u_int32_t help_data ;
  u_int32_t addr ;
  int i ;

  for (i=0;i<0x2000;i++)
   {
    addr = addr + i ;
   }

  addr = 0x40000400;

  help_data = 0 ;

  for (i=0;i<8;i++)
   {
      data = 0x0 ;
      return_code = s3100_sharc_write(p, addr, &data, 0x1) ;
      data = SDRAM_SCL ; 
      return_code = s3100_sharc_write(p, addr, &data, 0x1) ;

      return_code = s3100_sharc_read(p, addr, &data, 0x1) ;
      help_data = help_data << 1 ;
      help_data = help_data + ((data & 0x100) >> 8) ;  
   }

  *read_data =  help_data  ;

      data = SDRAM_SDA_OE + SDRAM_SDA ;
      return_code = s3100_sharc_write(p, addr, &data, 0x1) ;
      data = SDRAM_SDA_OE + SDRAM_SDA + SDRAM_SCL ; 
      return_code = s3100_sharc_write(p, addr, &data, 0x1) ;
      data = SDRAM_SDA_OE + SDRAM_SDA ;
      return_code = s3100_sharc_write(p, addr, &data, 0x1) ;
      data = 0x0 ;
      return_code = s3100_sharc_write(p, addr, &data, 0x1) ;

  return 0 ;
}



























