/* $ZEL: zellvd_rem_irq.c,v 1.6 2008/01/17 15:55:08 wuestner Exp $ */

/*
 * Copyright (c) 2005-2008
 * 	Peter Wuestner.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "sis1100_sc.h"

void
zellvd_rem_irq_handler(struct sis1100_softc* sc)
{
/*
 * sc->sem_irqinfo must be held by caller!
 */
    DECLARE_SPINLOCKFLAGS(s)
    u_int32_t irqs;

    SPIN_LOCK_IRQSAVE(sc->lock_doorbell, s);
    irqs=sc->doorbell;
    sc->new_irqs|=sc->doorbell&~sc->pending_irqs;
    sc->doorbell=0;
    SPIN_UNLOCK_IRQRESTORE(sc->lock_doorbell, s);
#if 0
    pERROR(sc, "lvd_irq: irqs=0x%x pending=0x%x new=0x%x",
            irqs, sc->pending_irqs, sc->new_irqs);
#endif
    sc->pending_irqs|=sc->new_irqs;
#if 0
    pINFO(sc, "lvdirq: 0x%08x", irqs);
#endif
}

/*
   sis1100_ddma_handler is here because it is used only by the 
   ZEL LVD DAQsystem.
   But it could also be used by any other front end.
   Then there is the problem that we need a bit in sc->new_irqs in order
   to let 'irq_pending' return TRUE.
   Here we use bit 30 of the IRQ word. Is it free in other cases too?
*/
void
sis1100_ddma_handler(struct sis1100_softc* sc)
{
/*
 * sc->sem_irqinfo must be held by caller!
 */
    sc->pending_irqs|=1<<30;
    sc->new_irqs|=1<<30;
}

void
zellvd_rem_enable_irqs(struct sis1100_softc* sc, struct sis1100_fdata* fd,
    u_int32_t mask)
{
}

void
zellvd_rem_disable_irqs(struct sis1100_softc* sc, struct sis1100_fdata* fd,
    u_int32_t mask)
{
}

void
zellvd_rem_irq_ack(struct sis1100_softc* sc, int irqs)
{
#if 0
    DECLARE_SPINLOCKFLAGS(flags)
    u_int32_t sr;

    lvd_readremreg(sc, sr, &sr, 0);
    if (sr&~sc->pending_irqs) {
#if 0
        pERROR(sc, "new extra irqs: 0x%x", sr&~sc->pending_irqs);
#endif
        SPIN_LOCK_IRQSAVE(sc->lock_doorbell, flags);
        sc->doorbell|=sr;
        SPIN_UNLOCK_IRQRESTORE(sc->lock_doorbell, flags);
        SPIN_LOCK_IRQSAVE(sc->handlercommand.lock, flags);
        sc->handlercommand.command|=handlercomm_doorbell;
        SPIN_UNLOCK_IRQRESTORE(sc->handlercommand.lock, flags);
        wakeup(&sc->handler_wait);
    }
#endif
}
