
/***************************************************************************/
/*                                                                         */
/*  Filename: vme_irq_with_sis3820.c                                       */
/*                                                                         */
/*  date:                 26.05.2010                                       */
/*  last modification:    26.05.2010  TH                                   */
/*                                                                         */
/*                                                                         */
/* ----------------------------------------------------------------------- */
/*                                                                         */
/*  SIS  Struck Innovative Systeme GmbH                                    */
/*                                                                         */
/*  Harksheider Str. 102A                                                  */
/*  22399 Hamburg                                                          */
/*                                                                         */
/*  Tel. +49 (0)40 60 87 305 0                                             */
/*  Fax  +49 (0)40 60 87 305 20                                            */
/*                                                                         */
/*  http://www.struck.de                                                   */
/*                                                                         */
/*  � 2010                                                                 */
/*                                                                         */
/***************************************************************************/

#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>

#include <fcntl.h>
#include <sys/ioctl.h>
#include <signal.h>

#include "dev/pci/sis1100_var.h"
#include "sis3100_vme_calls.h"

#include "sis3820.h"

//u_int32_t sis3801_base=0x38000000;
u_int32_t sis3820_base=0x38000000;

volatile int irq;
//int irqlevel=3;
//int irqvector=37;

unsigned int gl_vme_irq_level;
unsigned int gl_vme_irq_vector;
unsigned int gl_irq_loop_counter;

int Sis3820Init(int p, unsigned int mod_base, unsigned int vme_irq_level, unsigned int vme_irq_vector) ;
int Sis3820_Enable(int p, unsigned int mod_base) ;



/****************************************************************************/
#ifdef not_used
static int
vme_read(int p, u_int32_t base, int addr, u_int32_t *val)
{
    int res;
    struct sis1100_vme_req req;

    req.size=4;
    req.am=0x9;
    req.addr=base+addr;

    if ((res=ioctl(p, SIS3100_VME_READ, &req))<0) {
        printf("vme read 0x%08x: errno=%s\n", req.addr, strerror(errno));
        return -1;
    }
    if (req.error) {
        printf("vme read 0x%08x: error=0x%x\n", req.addr, req.error);
        return -1;
    }
    *val=req.data;
    return 0;
}
#endif

/****************************************************************************/
#ifdef raus
static int
vme_A32D32_write(int p, unsigned int addr, unsigned int data)
{
    struct sis1100_vme_req req;

    req.size=4;
    req.am=0x9;
    req.addr=addr;
    req.data=data;
    if ((ioctl(p, SIS3100_VME_WRITE, &req))<0) {
        printf("vme write 0x%08x: errno=%s\n", req.addr, strerror(errno));
        return -1;
    }
    if (req.error) {
        printf("vme write 0x%08x: error=0x%x\n", req.addr, req.error);
        return -1;
    }
    return 0;
}
#endif
/****************************************************************************/
static void
sighnd(int sig)
{
    irq=1;
        printf("irq\n");
}
/****************************************************************************/
int main(int argc, char* argv[])
{
    unsigned int data, offset ;
    int p,  error;
    struct sigaction action, old_action;
    struct sis1100_irq_ctl irqctl;
    struct sis1100_irq_get irqget;
    struct sis1100_irq_ack irqack;

    sigset_t mask, old_mask;

    if (argc!=2) {
        printf("usage: %s path\n", argv[0]);
        return 1;
    }

    if ((p=open(argv[1], O_RDWR, 0))<0) {
        printf("open %s: %s", argv[1], strerror(errno));
        return 1;
    }

    sigemptyset(&mask);
    sigaddset(&mask, SIGUSR1);
    sigprocmask(SIG_BLOCK, &mask, &old_mask);

    action.sa_handler=sighnd;
    sigemptyset(&action.sa_mask);
    action.sa_flags=0;
// mod1
   // sigaction(SIGUSR1, &action, &old_action);
    sigaction(SIGUSR1, &action, 0);


    gl_vme_irq_level = 1 ; // 1 to 7
    gl_vme_irq_vector = 0x11 ;
    error = Sis3820Init(p, sis3820_base, gl_vme_irq_level, gl_vme_irq_vector) ;

        printf("SIS3100_VME_IRQS %x\n", SIS3100_VME_IRQS);

    irqctl.irq_mask=SIS3100_VME_IRQS | SIS3100_FRONT_IRQS;
    irqctl.signal=SIGUSR1;
    if (ioctl(p, SIS1100_IRQ_CTL, &irqctl)<0) {
        printf("SIS1100_IRQ_CTL: %s\n", strerror(errno));
        return 1;    
    }

//#ifdef not_used
    /*
      this IRQ_ACK is only necessary because of a driver bug
      (it will be fixed in the next release (2.05))
    */
    irqack.irq_mask=0xffffffff;
    if (ioctl(p, SIS1100_IRQ_ACK, &irqack)<0) {
        printf("ioctl(SIS1100_IRQ_ACK): %s\n", strerror(errno));
        return 1;    
    }
//#endif



    gl_irq_loop_counter = 0; 
    Sis3820_Enable(p, sis3820_base) ;

    #define MAX_ILOOP	10  // every 1 sec. the next IRQ Level (sis3820 programmed to 10Hz)

  // test print
  offset = 0x84 ;
  error =  s3100_control_read(p, offset, &data) ; 
  //printf("s3100_control_read:   return_code = 0x%08x\n", error );         
  printf("s3100_control_read: offset = 0x%08x    data = 0x%08x\n", offset, data );         

  // test print
  offset = 0x104 ;
  error =  s3100_control_read(p, offset, &data) ; 
  printf("s3100_control_read: offset = 0x%08x    data = 0x%08x\n", offset, data );         

  // set "enable global VME IRQ" on SIS310x (new with 2.13) 
  offset = 0x104 ;
  error =  s3100_control_write(p, offset, 1) ; 
  // test print
  error =  s3100_control_read(p, offset, &data) ; 
  printf("s3100_control_read: offset = 0x%08x    data = 0x%08x\n", offset, data );         
 

   //while (count++<10) {
    while (1) {
        irq=0;

        printf("before sigsuspend\n");
	// wait for signal
        sigsuspend(&old_mask);
        printf("after sigsuspend\n");


        irqget.irq_mask=SIS3100_VME_IRQS;
        if (ioctl(p, SIS1100_IRQ_GET, &irqget)<0) {
            printf("ioctl(SIS1100_IRQ_GET): %s\n", strerror(errno));
            return 1;    
        }
	gl_irq_loop_counter++;

        printf(" irq-counter=%d  got irqs 0x%08x level=%d vector 0x%x\n", gl_irq_loop_counter,
                irqget.irqs, irqget.level, irqget.vector);

        if (!irqget.irqs) {
            printf("no irq bits set: impossible case\n");
            return 0;
        }

	// clear IRQ source flag on SIS3820 
	vme_A32D32_write(p, sis3820_base + SIS3820_IRQ_CONTROL ,SIS3820_IRQ_SOURCE0_CLEAR ) ; 




        // N loops over each IRQ Level
        if (gl_irq_loop_counter >= MAX_ILOOP) {
	    gl_irq_loop_counter = 0; 
	    // define next level	
	    if (gl_vme_irq_level == 7) {
		gl_vme_irq_level  = 1 ; // 
		gl_vme_irq_vector = 0x11 ;
	    }
	    else {
		gl_vme_irq_level  = gl_vme_irq_level + 1 ; // 
		gl_vme_irq_vector = gl_vme_irq_vector + 0x11 ;
	    }
	    // configure SIS3820 scaler again
	    error = Sis3820Init(p, sis3820_base, gl_vme_irq_level, gl_vme_irq_vector) ;
	    error = Sis3820_Enable(p, sis3820_base) ;
	} // N loops over each IRQ Level

        irqack.irq_mask=1<<irqget.level;
        if (ioctl(p, SIS1100_IRQ_ACK, &irqack)<0) {
            printf("ioctl(SIS1100_IRQ_ACK): %s\n", strerror(errno));
            return 1;    
        }


    }


    sigaction(SIGUSR1, &old_action, 0);

    close(p);
    return 0;    
}
/****************************************************************************/
/****************************************************************************/
/*********************************************************************************************************************************************/
/*	SIS3820 Scaler routines        ***********************************************************************************************************/
/*********************************************************************************************************************************************/
			


/***************************************************************************************************************************/
// the sis3820 generates an VME IRQ every 1ms (100ms) (depends on programmed prescaler factor)
int Sis3820Init(int p, unsigned int mod_base, unsigned int vme_irq_level, unsigned int vme_irq_vector) 
{
int return_code ;
unsigned int addr, data ;


/* reset  */
	addr = mod_base + SIS3820_KEY_RESET ;
	return_code = vme_A32D32_write(p, addr, 0x0) ;
	if (return_code != 0) {
      return return_code ;
    }

/* setup registers */
	
	/* enable irq source 0 (LNE Pulse; LNE: LoadNextEvent) */
	addr = mod_base + SIS3820_IRQ_CONTROL ;
	return_code = vme_A32D32_write(p, addr, SIS3820_IRQ_SOURCE0_ENABLE) ;  
	if (return_code != 0) {
      return return_code ;
    }

/* irq level ; vector  */
	addr = mod_base + SIS3820_IRQ_CONFIG ;
	data =  (vme_irq_vector & 0xff) + (((vme_irq_level & 0x7) + 0x8) << 8) ;
	return_code = vme_A32D32_write(p, addr, data) ;   
	if (return_code != 0) {
      return return_code ;
    }
 
//  setup LNE prescaler factor  
	addr = mod_base + SIS3820_LNE_PRESCALE ;                    /*  prescaler factor */
	//return_code = vme_A32D32_write(p, addr, 9999) ; //  set prescaler factor to to 1000Hz 
	return_code = vme_A32D32_write(p, addr, 999999) ; //  set prescaler factor to to 10Hz 
	//return_code = vme_A32D32_write(p, addr, 19999999) ; //  set prescaler factor to to 0.5Hz 
	if (return_code != 0) {
      return return_code ;
    }


/*  set operation mode */
	data = SIS3820_OP_MODE_MULTI_CHANNEL_SCALER ;      /* Multi channel scaler */
	data = data + SIS3820_LNE_SOURCE_INTERNAL_10MHZ ;  /* 100ns x (prescaler_factor-1) */
	data = data + SIS3820_MCS_DATA_FORMAT_24BIT ;      /* 24-bit format                */
	addr = mod_base + SIS3820_OPERATION_MODE ;                    /*    */

	return_code = vme_A32D32_write(p, addr, data) ; /*  */
	if (return_code != 0) {
      return return_code ;
    }

return 0 ;
}



int Sis3820_Enable(int p, unsigned int mod_base) 
{
int return_code ;
unsigned int addr ;

/* enable logic  */
	addr = mod_base + SIS3820_KEY_OPERATION_ENABLE ;                   
	return_code = vme_A32D32_write(p, addr, 0x0) ;
	if (return_code != 0) {
      return return_code ;
    }

return 0 ;
}




