/***************************************************************************/
/*                                                                         */
/*   Name:  imago.asm                                                      */
/*                                                                         */
/*   RSS SIS9200 DSP code                                                  */
/*                                                                         */
/*   Author: MKI                                                           */
/*                                                                         */
/*   Date: 29.04.2002  Imago D16 test code                                 */
/*         29.05.02 store data                                             */
/*         03.06.02 full readout/2 buffers                                 */
/*                                                                         */
/* ----------------------------------------------------------------------- */
/*                                                                         */
/*                                                                         */
/*  Copyright (c) 2002 SIS GmbH 22399 Hamburg.  All rights reserved.       */
/*                                                                         */
/*                                                                         */
/***************************************************************************/

/* header Dateien */	
#include "..\header\def21060.h"
#include "..\header\s3100def.h"

/* */
#define IRQ1_VECTOR_ADDR 0x0002001C
			
/* --- Defines fuer die SHARC-Adressen und Befehle ----------------------- */
#define SYSCON  0x00    
#define WAIT    0x02

// Sharc Local defines
#define LOC_SEQ_STATUS 				        0x01000000


// Sharc VME MAster defines
#define VME_DATA_FIFO_READ 			    	0x40000000
#define VME_ONLY_ARBITRATION_CYCLE	    	        0x40080000
#define VME_ONLY_RELEASE_MASTER_CYCLE		        0x40000000
#define VME_DMA_CYCLE					0x40040000
#define VME_SINGLE_CYCLE				0x40020000
#define INTERNAL_SINGLE_CYCLE				0x40030000

#define READ_FIFO_DISABLE 				0x00800000
#define READ_FIFO_CLR_DISABLE   			0x00400000
#define WORD_COUNT_CLR_DISABLE  			0x00200000    
#define VME ADDR_INC_DISABLE 				0x00100000

#define VME_HOLD_MASTER				        0x00080000
#define VME_WRITE					      0x40
#define VME_AM_F				      	      0x0F
#define VME_AM_9				      	      0x09
#define VME_AM_29				      	      0x29

#define VME_WRITE_DATA_REG				0x20000001
#define VME_DMA_MAX_WORDCOUNT				0x20000002
#define VME_READ_DATA_REG				0x20000008


// Sharc SDRAM defines
#define SDRAM_BLT_BASE		 			0x80000000
#define SDRAM_SGL_BASE		 			0xC0000000
#define SDRAM_RD_ADD_WR_BASE 			   	0xE0000000
#define SDRAM_RING_BASE                                 0xC0800000
	
#define SHARCIO 0x01000004
#define BANK0FLAG                                       0x20000100
#define BANK1FLAG                                       0x20000101	

	
/* Macros */	
#define nimpulse1(lbl) BIT CLR ASTAT 0x80000;  \
lbl:	                                       \
	                  BIT SET ASTAT 0x80000 


.SEGMENT/PM     seg_pm1;
			
Start:
	    JUMP (PC,IRQSETUP)	; 
Mirrow_IRQ1_Vector:
	    R12=R12+1		        ; /* increment IRQ counter     */
	    R15=DM(LOC_IO_IN_REG)	; /* get latched signals       */
	    DM(LOC_IO_IN_REG)=R15	; /* clear all latched signals */
	    RTI; 
IRQSETUP:	
	    M13=1		;
	    I13=Mirrow_IRQ1_Vector;
	    I14=IRQ1_VECTOR_ADDR	;
	    /* copy 4 lines */
	    LCNTR=0x4,DO(PC,2) UNTIL LCE;
	    PX=PM(I13,M13)	;
	    PM(I14,M13)=PX	;

	    R12=0		; /* clear IRQ count */
	    R11=10		; /* IRQ threshold   */
	
	    R6=0x2004EAA5 ;    
		nop ;
	    DM(WAIT)=R6  ;  
	    nop ;
	    BIT SET MODE2 0x78000; /* Flag 3 .. Flag 0 sind outputs */ 
	    BIT CLR ASTAT 0x80000 ; /* clr Flag 0 ; Led an */

	    I1=0x2		;
	    DM(INTERNAL_SINGLE_CYCLE_WR,I1)=R0;
	    R15=0xff00		;
	    DM (LOC_IO_IN_REG)=R15;  /* clear latched input bits */
	    BIT SET IMASK IRQ1I	;    /* enable IRQ1 on SHARC (inputs) */
	    BIT SET MODE2 IRQ1E	;    /* set IRQ1 to edge sensitive */
	    BIT SET MODE1 IRPTEN;    /* enable IRQs on SHARC */
	    I1=0x1002           ;
	    DM(INTERNAL_SINGLE_CYCLE_WR,I1)=R0;

// clear SDRAM

		I1 = SDRAM_SGL_BASE ; /* SDRAM Single Cycle or LAST BLT Cycle */
		M1 = 0x1 ;      
		R1 = 0x0 ;
	        R2 = 0x1000000	;  /* lowest 16 MByte */

                LCNTR=R2, DO (PC,1)  UNTIL LCE ;
   		DM(I1,M1) = R1  ;  /* Single Write ; clr  */
// clear buffer flags	
                DM(BANK0FLAG)=R0	       ;         // clear bank flag  
                DM(BANK1FLAG)=R0	       ;         // clear bank flag  
	
LOOP_START:


// note:	odd byte access -> d16 access
	        R10 = 0xC10B        ;  // hit register 
	        R13 = 0xFF          ;  // hit mask

		R0 =  0xC113        ;  // address selector
		R1 =  0xC117        ;  // address RT1, reflects 0xC122
		R2 =  0xC119        ;  // address RT2, reflects 0xC124
	        R3 =  0xFFFF        ;  // mask for lower 16-bits
	        R4 =  0xFFFFFFFF    ; 
	        R5 =  0		    ;  // event number
                R6 =  0             ;  // buffer number
	        
                I8 =  0x0           ; // 8
	        I9 =  0x1           ; // 9
	        I10 =  0x2          ; // a
	        I11 =  0x3          ; // b
	        R7 =  0xC111	    ; 
                I7=0xFFF	    ; 
                M3=1		    ; // postincrement by 1
	        I3=SDRAM_SGL_BASE   ; // single access SDRAM address
	        I2=0		    ; 


Hit_Wait:
 	DM (VME_SINGLE_CYCLE + VME_AM_29 ) = R10 ; // start hit reg read
	DM (VME_WRITE_DATA_REG) = I8   ;         // preload 1st write data
VMEHITWAIT:
	R14 = R12		       ;         // store trigger counter 
 	R15 = DM (LOC_SEQ_STATUS)      ;         //    	 
        BTST R15 by 0		       ;         // wait for VME cycle to complete 
 	IF NOT SZ JUMP (PC,VMEHITWAIT) ;         // 
	R11 =  DM(VME_READ_DATA_REG)   ;         // read hit data   
	R11 =  R11 AND R13	       ;         // mask with 0xff
	IF EQ JUMP (PC,Hit_Wait)       ;         // hit or not?
	
 	DM (VME_SINGLE_CYCLE + VME_HOLD_MASTER + VME_WRITE + VME_AM_29 ) = R0 ;
//	DM(I3,M3)=R5		       ;         // store event number
	DM(I3,M3)=R14		       ;         // store counts
	R12=R12-R14		       ;         // subtract counts 
	DM (VME_WRITE_DATA_REG) = I9   ;         // preload 2nd write data
// ***************************************************************************************
VMEWAIT1:
 	R15 = DM (LOC_SEQ_STATUS)      ;     	 
        BTST R15 by 0                  ;	
 	IF NOT SZ JUMP (PC,VMEWAIT1)   ;  
 	DM (VME_SINGLE_CYCLE + VME_HOLD_MASTER + VME_AM_29 ) = R1 ; // RT1 read
VMEWAIT2:
 	R15 = DM (LOC_SEQ_STATUS)      ;     	 
        BTST R15 by 0                  ;	
 	IF NOT SZ JUMP (PC,VMEWAIT2)   ;  
 	DM (VME_SINGLE_CYCLE + VME_HOLD_MASTER + READ_FIFO_CLR_DISABLE + VME_AM_29 ) = R2 ; // RT2 read
	R8 = DM(VME_DATA_FIFO_READ)    ;         // read VME datum
	R8 = LSHIFT R8 BY 16           ; 

VMEWAIT3:
 	R15 = DM (LOC_SEQ_STATUS)      ;     	 
        BTST R15 by 0                  ;	     // wait for completion
 	IF NOT SZ JUMP (PC,VMEWAIT3)   ;  
 	DM (VME_SINGLE_CYCLE + VME_HOLD_MASTER + VME_WRITE + VME_AM_29 ) = R0 ;
	DM (VME_WRITE_DATA_REG) = I10  ;         // preload 3rd write data
	R9 = DM(VME_DATA_FIFO_READ)    ;         // read VME datum
	R9 = R9 AND R3                 ;         // and lower data
        R8 = R8 OR R9		       ;         // combine 2 16-bit reads
	DM(I3,M3)=R8		       ;         // store 1st TDC value 

// ***************************************************************************************
VMEWAIT4:
 	R15 = DM (LOC_SEQ_STATUS)      ;     	 
        BTST R15 by 0                  ;	     // wait for completion 
 	IF NOT SZ JUMP (PC,VMEWAIT4)   ;  
 	DM (VME_SINGLE_CYCLE + VME_HOLD_MASTER + READ_FIFO_CLR_DISABLE + VME_AM_29 ) = R1 ; // RT1 read
VMEWAIT5:
 	R15 = DM (LOC_SEQ_STATUS)      ;     	 
        BTST R15 by 0                  ;	     // wait for completion 
 	IF NOT SZ JUMP (PC,VMEWAIT5)   ;  
 	DM (VME_SINGLE_CYCLE + VME_HOLD_MASTER + READ_FIFO_CLR_DISABLE + VME_AM_29 ) = R2 ; // RT2 read
	R8 = DM(VME_DATA_FIFO_READ)     ;         // read VME datum
	R8 = LSHIFT R8 BY 16           ; 
	
VMEWAIT6:
 	R15 = DM (LOC_SEQ_STATUS)      ;     	 
        BTST R15 by 0                  ;	     // wait for completion 
 	IF NOT SZ JUMP (PC,VMEWAIT6)   ;  
 	DM (VME_SINGLE_CYCLE + VME_HOLD_MASTER + VME_WRITE + VME_AM_29 ) = R0 ;
	R9 = DM(VME_DATA_FIFO_READ)    ;         // read VME datum
	R9 = R9 AND R3                 ;         // shift down
        R8 = R8 OR R9		       ;         // combine 2 16-bit reads
	DM(I3,M3)=R8		       ;         // store 2nd TDC value 
	DM (VME_WRITE_DATA_REG) = I11  ;         // preload 4th write data

// ***************************************************************************************
VMEWAIT7:
 	R15 = DM (LOC_SEQ_STATUS)      ;     	 
    BTST R15 by 0                  ;	     // wait for completion 
 	IF NOT SZ JUMP (PC,VMEWAIT7)   ;  
 	DM (VME_SINGLE_CYCLE + VME_HOLD_MASTER + READ_FIFO_CLR_DISABLE + VME_AM_29 ) = R1 ; // RT1 read
VMEWAIT8:
 	R15 = DM (LOC_SEQ_STATUS)      ;     	 
        BTST R15 by 0                  ;	     // wait for completion 
 	IF NOT SZ JUMP (PC,VMEWAIT8)   ;  
 	DM (VME_SINGLE_CYCLE + VME_HOLD_MASTER + READ_FIFO_CLR_DISABLE + VME_AM_29 ) = R2 ; // RT2 read
	R8 = DM(VME_DATA_FIFO_READ)     ;         // read VME datum
	R8 = LSHIFT R8 BY 16           ; 
VMEWAIT9:
 	R15 = DM (LOC_SEQ_STATUS)      ;     	 
        BTST R15 by 0                  ;	     // wait for completion 
 	IF NOT SZ JUMP (PC,VMEWAIT9)   ;   
        DM (VME_SINGLE_CYCLE + VME_HOLD_MASTER + VME_WRITE + VME_AM_29 ) = R0 ;
	R9 = DM(VME_DATA_FIFO_READ)    ;         // read VME datum
	R9 = R9 AND R3                 ;         // shift down
        R8 = R8 OR R9		           ;         // combine 2 16-bit reads
	DM(I3,M3)=R8		           ;         // store 4th TDC value 
// ***************************************************************************************
VMEWAIT10:
 	R15 = DM (LOC_SEQ_STATUS)      ;     	 
        BTST R15 by 0                  ;	 // wait for completion 
 	IF NOT SZ JUMP (PC,VMEWAIT10)  ;  
 	DM (VME_SINGLE_CYCLE + VME_HOLD_MASTER + READ_FIFO_CLR_DISABLE + VME_AM_29 ) = R1 ; // RT1 read
VMEWAIT11:
 	R15 = DM (LOC_SEQ_STATUS)      ;     	 
        BTST R15 by 0                  ;	 // wait for completion 
 	IF NOT SZ JUMP (PC,VMEWAIT11)  ;  
 	DM (VME_SINGLE_CYCLE + VME_HOLD_MASTER + READ_FIFO_CLR_DISABLE + VME_AM_29 ) = R2 ; // RT2 read, release mastership
	R8 = DM(VME_DATA_FIFO_READ)    ;         // read VME datum
	R8 = LSHIFT R8 BY 16           ;
	DM(VME_WRITE_DATA_REG)=I7      ; 
VMEWAIT12:
 	R15 = DM (LOC_SEQ_STATUS)      ;     	 
        BTST R15 by 0                  ;	 // wait for completion 
 	IF NOT SZ JUMP (PC,VMEWAIT12)  ;  
	R9 = DM(VME_DATA_FIFO_READ)    ;         // read VME datum
	R9 = R9 AND R3                 ;         // shift down
        R8 = R8 OR R9		       ;         // combine 2 16-bit reads
	DM(I3,M3)=R8		       ;         // store 4th TDC value 
//      reset hit, rearm
        DM (VME_SINGLE_CYCLE + VME_WRITE + VME_AM_29 ) = R7 ;
	R5 = R5+1		       ;         // increment event number
	BTST R5 by 17		       ;
	IF SZ JUMP (PC,NOBUFCHNG)      ;
	BTST R6 by 0		       ;
	IF SZ JUMP (PC,WASBUF0)        ;
        DM(BANK1FLAG)=R5	       ;         // set bank flag 
	R5 = 0			       ;         // clear envent number  
	R6 = 0		               ;         // new buffer is 0 
WAITBK0:	                   
	R15=DM(BANK0FLAG)	       ;
	R15 = R15 AND R4	       ; 
	IF NE JUMP (PC,WAITBK0)        ; 
	I3=SDRAM_SGL_BASE	       ;         // buf0 address
JUMP NOBUFCHNG		               ; 
WASBUF0:
        DM(BANK0FLAG)=R5	       ;         // set bank flag  
	R5 = 0			       ;         // clear envent number  
	R6 = 1			       ; 
WAITBK1:
	R15=DM(BANK1FLAG)	       ; 
	R15 = R15 AND R4	       ; 
	IF NE JUMP (PC,WAITBK1)        ; 
	I3=SDRAM_SGL_BASE+0x100000     ;         // buf1 address
NOBUFCHNG:	 
VMEWAIT13:
        R15 = DM (LOC_SEQ_STATUS)      ;
        BTST R15 by 0                  ;         // wait for completion
        IF NOT SZ JUMP (PC,VMEWAIT13)  ;	        
 	JUMP (PC,Hit_Wait)             ;

	.ENDSEG;


















