/*
 * $ZEL$
 */

#ifndef _test_3100_h_
#define _test_3100_h_

#define _GNU_SOURCE

#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <time.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <sys/ioctl.h>

#include "dev/pci/sis1100_var.h"

#ifndef SIS1100_Version
#   define MAJORVERSION 1
#   define MINORVERSION 0
#else
#   define MAJORVERSION ((SIS1100_Version>>16)&0xffff)
#   define MINORVERSION (SIS1100_Version&0xffff)
#endif

#if MAJORVERSION < 2
enum sis1100_subdev {sis1100_subdev_remote, sis1100_subdev_ram,
    sis1100_subdev_dsp};
#endif

#define VMESTART 0x84000000

struct path {
    char* name;
    enum sis1100_subdev type;
    int p;
    int majorversion;
    int minorversion;
    u_int32_t mapsize;
    volatile u_int32_t* map;
    struct sis1100_ident ident;
};

extern u_int32_t* buf;
extern int bufsize;

int init_path(struct path* path);
int done_path(struct path* path);
int vme_probe(struct path* path, u_int32_t addr);
int check_reopen(struct path* path);
int check_rw(struct path* path);
int check_MAPSIZE(struct path* path);
int check_mmap(struct path* path);
int check_IDENT(struct path* path);
int check_rw_single(struct path* path, u_int32_t start, u_int32_t size);
int check_r_block(struct path* path, u_int32_t start, u_int32_t max);
int check_w_block(struct path* path, u_int32_t start, u_int32_t max);
int check_VME_BLOCK_READ(struct path* path, u_int32_t start, u_int32_t size);

#endif
