/*
 * $ZEL$
 */

#include "test_3100.h"

int
check_rw_single(struct path* path, u_int32_t start, u_int32_t size)
{
    u_int32_t *in, *out;
    int i, res, first, count;

    in=calloc(size, 4);
    out=calloc(size, 4);
    if (!in || !out) {
        printf("cannot allocate %d words for in- and output\n", size);
        free(in); free(out);
        return -1;
    }

    for (i=0; i<size; i++) {
        out[i]=random();
        in[i]=~out[i];
    }
    if (lseek(path->p, start, SEEK_SET)!=start) {
        printf("check_rw_single: lseek(%s, 0x%08x, SEEK_SET): %s\n",
                path->name, start, strerror(errno));
        return -1;
    }
    for (i=0; i<size; i++) {
        res=write(path->p, out+i, 4);
        if (res!=4) {
            printf("write(%s, ..., 4): %s\n", path->name, strerror(errno));
            return -1;
        }
    }
    if (lseek(path->p, start, SEEK_SET)!=start) {
        printf("check_rw_single: lseek(%s, 0x%08x, SEEK_SET): %s\n",
                path->name, start, strerror(errno));
        return -1;
    }
    for (i=0; i<size; i++) {
        res=read(path->p, in+i, 4);
        if (res!=4) {
            printf("read(%s, ..., 4): %s\n", path->name, strerror(errno));
            return -1;
        }
    }
    first=1; count=0;
    for (i=0; i<size; i++) {
        if (in[i]!=out[i]) {
            if (first) {
                printf("%s: rw error:", path->name);
                first=0;
            }
            printf("[%3d]: %08x --> %08x\n", i, out[i], in[i]);
            count++;
        }
    }
    return count?-1:0;
}

