/*
 * $ZEL$
 */

#include "test_3100.h"

int
init_path(struct path* path)
{
    path->type=-1;
    path->p=-1;
    path->mapsize=0;
    path->map=0;

    path->p=open(path->name, O_RDWR, 0);
    if (path->p<0) {
        printf("open \"%s\": %s\n", path->name, strerror(errno));
        return -1;
    }
    if (ioctl(path->p, SIS1100_DEVTYPE, &path->type)<0) {
        printf("ioctl(%s, SIS1100_DEVTYPE): %s\n",
                path->name, strerror(errno));
        return -1;
    }

#ifdef SIS1100_DRIVERVERSION
    {
    int version;
    if (ioctl(path->p, SIS1100_DRIVERVERSION, &version)<0) {
        printf("ioctl(%s, SIS1100_DRIVERVERSION):\n    %s\n",
                path->name, strerror(errno));
        if (MAJORVERSION>1) {
            printf("    Major version does not match; path cannot be used\n");
            return -1;
        }
    } else {
        path->majorversion=(version>>16)&0xffff;
        path->minorversion=version&0xffff;
        printf("%s: driverversion is %d.%d\n",
            path->name,
            path->majorversion,
            path->minorversion);
        if (path->majorversion!=MAJORVERSION) {
            printf("Major version does not match; path cannot be used\n");
            return -1;
        }
    }
    }
#else
    if (MAJORVERSION>1) {
        printf("    Major version does not match; path cannot be used\n");
        return -1;
    }
#endif

    switch (path->type) {
    case sis1100_subdev_remote:
        printf("%s is <REMOTE>\n", path->name);
        break;
    case sis1100_subdev_ram:
        printf("%s is RAM\n", path->name);
        break;
#if MAJORVERSION >= 2
    case sis1100_subdev_ctrl:
        printf("%s is CTRL\n", path->name);
        break;
#endif
    case sis1100_subdev_dsp:
        printf("%s is DSP\n", path->name);
        break;
    default:
        printf("init_path: %s has unknown type %d\n",
                path->name, path->type);
        return -1;
    }
    return 0;
}

int
done_path(struct path* path)
{
    if (path->map) {
        if (munmap((u_int32_t*)path->map, path->mapsize)<0)
            printf("munmap(%s): %s\n",
                path->name, strerror(errno));
    }
    if (path->p>=0) close(path->p);
    return 0;
}

