/* $ZEL: vertex_map.h,v 1.2 2004/05/27 23:10:48 wuestner Exp $ */

/*
 * Copyright (c) 2004
 * 	Peter Wuestner.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _vertex_map_h_
#define _vertex_map_h_

struct vertex_reg {
    u_int32_t ident;              /* 0x000 */
    u_int32_t sc;         /* 0x004 */
    u_int32_t optical_cr;         /* 0x008 */
    u_int32_t dsp_sc;             /* 0x008 */
    u_int32_t dummy;
};

/* bits in in_out */
#define vertex_io_flat_out1 (1<<0)
#define vertex_io_flat_out2 (1<<1)
#define vertex_io_flat_out3 (1<<2)
#define vertex_io_flat_out4 (1<<3)
#define vertex_io_lemo_out1 (1<<4)
#define vertex_io_lemo_out2 (1<<5)
#define vertex_io_lemo_out3 (1<<6)
/* clear is (io_*_out?)<<16 */
#define vertex_io_flat_in1 (1<<16)
#define vertex_io_flat_in2 (1<<17)
#define vertex_io_flat_in3 (1<<18)
#define vertex_io_flat_in4 (1<<19)
#define vertex_io_lemo_in1 (1<<20)
#define vertex_io_lemo_in2 (1<<21)
#define vertex_io_lemo_in3 (1<<22)

/* bits in dsp_sc */
#define vertex_dsp_run        (1<<8)
#define vertex_dsp_boot_eprom (1<<9)
#define vertex_dsp_boot_ctrl  (1<<11)

#define vertex_dsp_available  (1<<24)
#define vertex_dsp_flag0      (1<<28)
#define vertex_dsp_flag1      (1<<29)
#define vertex_dsp_flag2      (1<<30)
#define vertex_dsp_flag3      (1<<31)

/* error codes */
#define vertex_sis3100_re_berr        0x211 /* Bus Error */
#define vertex_sis3100_re_retr        0x212 /* Retry */
#define vertex_sis3100_re_atimeout    0x214 /* Arbitration timeout */

#endif
