/* $ZEL: compat_linux.h,v 1.9 2006/02/14 19:51:12 wuestner Exp $ */

/*
 * Copyright (c) 2003-2004
 * 	Peter Wuestner.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _compat_linux_h_
#define _compat_linux_h_

#include <linux/config.h>
#include <linux/version.h>
#include <linux/init.h>
#include <linux/types.h>
#include <linux/pci.h>
#include <linux/module.h>
#include <linux/interrupt.h>
#include <linux/mm.h>
#include <linux/poll.h>
#include <asm/poll.h>
#include <asm/uaccess.h>

#define ofs(what, elem) ((off_t)&(((what *)0)->elem))

#define _plxreadreg_4(sc, offset) readl((sc)->plxmembase+(offset))
#define _plxwritereg_4(sc, offset, val) writel(val, (sc)->plxmembase+(offset))
#define _plxreadreg_1(sc, offset) readb((sc)->plxmembase+(offset))
#define _plxwritereg_1(sc, offset, val) writeb(val, (sc)->plxmembase+(offset))

#define _plxreadlocal0_4(sc, offset) readl((sc)->reg_base+(offset))
#define _plxwritelocal0_4(sc, offset, val) writel(val, (sc)->reg_base+(offset))
#define _plxrawreadlocal0_4(sc, offset) __raw_readl((sc)->reg_base+(offset))
#define _plxrawwritelocal0_4(sc, offset, val) __raw_writel(val, (sc)->reg_base+(offset))

#define _plxreadlocal1_4(sc, offset) readl((sc)->rem_base+(offset))
#define _plxwritelocal1_4(sc, offset, val) writel(val, (sc)->rem_base+(offset))
#define _plxreadlocal1_2(sc, offset) readw((sc)->rem_base+(offset))
#define _plxwritelocal1_2(sc, offset, val) writew(val, (sc)->rem_base+(offset))

#define pINFOsc(fmt, arg...) \
    printk(KERN_INFO "sis1100: " fmt "\n" , ## arg)
#define pINFO(sc, fmt, arg...) \
    printk(KERN_INFO "sis1100[%d]: " fmt "\n", sc->unit , ## arg)
#define pWARNING(sc, fmt, arg...) \
    printk(KERN_WARNING "sis1100[%d]: " fmt "\n", sc->unit , ## arg)
#define pERROR(sc, fmt, arg...) \
    printk(KERN_ERR "sis1100[%d]: " fmt "\n", sc->unit , ## arg)
#ifdef DEBUG
#define pDEBUG(sc, fmt, arg...) \
    printk(KERN_ERR "sis1100[%d]_debug: " fmt "\n", sc->unit , ## arg)
#else
#define pDEBUG(sc, fmt, arg...) \
    do {} while(0)
#endif

#ifndef NBPG
#define NBPG PAGE_SIZE
#endif

#define DECLARE_SPINLOCKFLAGS(flags) unsigned long flags;
#define SPIN_LOCK_IRQSAVE(lock, flags) spin_lock_irqsave(&(lock), flags)
#define SPIN_UNLOCK_IRQRESTORE(lock, flags) spin_unlock_irqrestore(&(lock), flags)

#define SEM_LOCK(sem) down(&(sem))
#define SEM_UNLOCK(sem) up(&(sem))

#define KFREE(p) kfree(p)
#define KMALLOC(s) kmalloc(s, GFP_KERNEL)

#define ACCESS_OK(buf, count, write) \
    access_ok(write?VERIFY_READ:VERIFY_WRITE, buf, count)

#define COPY_TO_USER(dest, src, size) \
    copy_to_user(dest, src, size)

#define wakeup(x) wake_up(x)

#define RMB(t, h, o, l) rmb()
#define WMB(t, h, o, l) wmb()
#define MB(t, h, o, l) mb()

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,23)
typedef void irqreturn_t;
#define IRQ_NONE
#define IRQ_HANDLED
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0)
#define SIGMASK_LOCK sigmask_lock
#else
#define SIGMASK_LOCK sighand->siglock
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0)
static inline unsigned iminor(struct inode *inode)
{
	return MINOR(inode->i_rdev);
}
#endif

#define LINUX_RETURN(x) return -(x)

int sgl_map_user_pages(struct scatterlist *sgl, const unsigned int max_pages, 
        const char* uaddr, size_t count, int rw);
int sgl_unmap_user_pages(struct scatterlist *sgl, const unsigned int nr_pages,
        int dirtied);
void dump_sgl(struct scatterlist *sgl, int nr_pages);

#endif
